// Copyright (C) 2011 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gfx/skeletal_mesh.hh"

#include <glm/gtc/matrix_access.hpp>
#include <glm/gtx/matrix_interpolation.hpp>
#include "nv/interface/context.hh"
#include "nv/interface/device.hh"


nv::skeletal_mesh::skeletal_mesh( device* a_device, md5_mesh_data* a_mesh_data )
	: animated_mesh()
	, m_mesh_data( nullptr )
	, m_animation( nullptr )
	, m_animation_time( 0 )
{
	m_mesh_data = a_mesh_data->spawn();
	m_va        = a_device->create_vertex_array( a_mesh_data, nv::STREAM_DRAW );
}


void nv::skeletal_mesh::setup_animation( md5_animation* a_anim )
{
	m_animation      = a_anim;
	m_animation_time = 0;
	if ( m_animation )
	{
		m_transform.resize( m_animation->get_num_joints() );
		update( 0 );
	}
}

void nv::skeletal_mesh::update( uint32 ms )
{
	if ( m_animation )
	{
		m_animation_time += ms;
		float frame_duration = 1000.f / (float)m_animation->get_frame_rate();
		uint32 anim_duration = uint32( frame_duration * (float)m_animation->get_frame_count() );
		while ( m_animation_time >= anim_duration ) m_animation_time -= anim_duration;
		m_animation->update_skeleton( m_transform.data(), (float)m_animation_time * 0.001f );
		m_mesh_data->apply( m_transform.data() );
		vertex_buffer* vb = m_va->find_buffer( nv::POSITION );
		vb->bind();
		vb->update( m_mesh_data->data(), 0, m_mesh_data->size() );
		vb->unbind();
	}
}

nv::skeletal_mesh::~skeletal_mesh()
{
	delete m_va;
	delete m_mesh_data;
}

void nv::skeletal_mesh::run_animation( animation_entry* a_anim )
{
	if ( a_anim != nullptr )
	{
		skeletal_animation_entry * anim = down_cast<skeletal_animation_entry>(a_anim);
		setup_animation( anim->m_animation );
	}
	else
	{
		setup_animation( nullptr );
	}
}
