// Copyright (C) 2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_ROGUE_FOV_RECURSIVE_SHADOWCASTING_HH
#define NV_ROGUE_FOV_RECURSIVE_SHADOWCASTING_HH

#include <nv/common.hh>
#include <nv/position.hh>
#include <nv/rogue/fov.hh>

namespace nv
{

	namespace rogue
	{

		class fov_recursive_shadowcasting : public fov_algorithm
		{
		public:
			fov_recursive_shadowcasting( bool light_walls = true ) 
				: m_light_walls( light_walls ) {}
			virtual void initialize( fov_interface* map, const dimension& size )
			{
				m_map  = map;
				m_size = size;
			}
			virtual void run( const position& p, uint16 radius );
		private:
			void cast_light( int row,float start, float end, int oct );

			bool           m_light_walls;
			int            m_radius;
			int            m_radius2;
			position       m_position;
			dimension      m_size;
			fov_interface* m_map;
		};

	}

}

#endif // NV_ROGUE_FOV_RECURSIVE_SHADOWCASTING_HH
