// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/fmod/fmod_audio.hh"

#include "nv/lib/fmod.hh"
#include "nv/logging.hh"

using namespace nv;

fmod::audio::audio()
{
	m_system = nullptr;

	nv::load_fmod_library();

	FMOD_RESULT result;
	FMOD_SYSTEM* system;

	result = FMOD_System_Create( &system );
	if ( result != FMOD_OK )
	{
		NV_LOG( LOG_CRITICAL, "Failed to create FMOD System -- " << FMOD_ErrorString( result ) );
		return;
	}
	result = FMOD_System_Init( system, 64, FMOD_INIT_NORMAL, 0 );
	if ( result != FMOD_OK )
	{
		NV_LOG( LOG_ERROR, "Failed to initialize FMOD System -- " << FMOD_ErrorString( result ) );
		return;
	}
	m_system = system;
}


nv::channel* fmod::audio::play_sound( nv::sound* a_sound )
{
	FMOD_SYSTEM* system = (FMOD_SYSTEM*)m_system;
	FMOD_SOUND* sample  = (FMOD_SOUND*)( down_cast< fmod::sound >( a_sound )->m_sound );
	FMOD_RESULT result  = FMOD_System_PlaySound( system, FMOD_CHANNEL_FREE, sample, false, 0 );
	if ( result != FMOD_OK )
	{
		NV_LOG( LOG_WARNING, "FMOD failed to play sound -- " << FMOD_ErrorString( result ) );
	}
	return nullptr;
}

nv::sound* fmod::audio::load_sound( const std::string& a_path )
{
	FMOD_SYSTEM* system = (FMOD_SYSTEM*)m_system;
	FMOD_SOUND* sample;
	FMOD_RESULT result = FMOD_System_CreateSound( system, a_path.c_str(), FMOD_DEFAULT, 0, &sample );
	if ( result != FMOD_OK )
	{
		NV_LOG( LOG_ERROR, "FMOD failed to load sample '" << a_path << "' -- " << FMOD_ErrorString( result ) );
		return nullptr;
	}
	return new fmod::sound( sample );
}

void fmod::audio::update()
{
	FMOD_System_Update( (FMOD_SYSTEM*)m_system );
	// no-op
}

fmod::audio::~audio()
{
	FMOD_System_Release( (FMOD_SYSTEM*)m_system );
}

fmod::sound::~sound()
{
	FMOD_Sound_Release( (FMOD_SOUND*)m_sound );
}
