// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LIB_GL_HH
#define NV_LIB_GL_HH

#include <nv/common.hh>

#if NV_PLATFORM == NV_WINDOWS
#  ifndef WIN32_LEAN_AND_MEAN
#    define WIN32_LEAN_AND_MEAN 1
#  endif
#include <windows.h>
#  undef WIN32_LEAN_AND_MEAN
#  undef near
#  undef far
#endif

#include <stddef.h>

//#define NV_SDL_GL
#define NV_GL_DYNAMIC
//#define NV_GL_SHARED

#if NV_PLATFORM == NV_WINDOWS
#	define NV_GL_PATH "opengl32.dll"
#elif NV_PLATFORM == NV_APPLE
#	define NV_GL_PATH "/System/Library/Frameworks/OpenGL.framework/Libraries/libGL.dylib"
#else
#	define NV_GL_PATH "libGL.so"
#endif

#include <stdint.h>

extern "C" {

#if NV_PLATFORM == NV_WINDOWS 
#	define NV_GL_APIENTRY __stdcall
#else
#	define NV_GL_APIENTRY 
#endif

#if defined(NV_GL_SHARED) && (NV_PLATFORM == NV_WINDOWS)
#	define NV_GL_API __declspec(dllimport)
#else
#	define NV_GL_API extern
#endif

#include <nv/lib/detail/gl_types.inc>
#if NV_PLATFORM == NV_WINDOWS
#include <nv/lib/detail/wgl_types.inc>
#endif

#if defined(NV_GL_DYNAMIC)
#	define NV_GL_FUN_REN( rtype, fname, rname, fparams ) NV_GL_API rtype ( NV_GL_APIENTRY *rname) fparams
#	define NV_GL_FUN( rtype, fname, fparams ) NV_GL_API rtype ( NV_GL_APIENTRY *fname) fparams
#else
#	define NV_GL_FUN( rtype, fname, fparams ) NV_GL_API rtype NV_GL_APIENTRY fname fparams
#endif
#define NV_GL_FUN_EXT NV_GL_FUN

#include <nv/lib/detail/gl_functions.inc>
#if NV_PLATFORM == NV_WINDOWS
#include <nv/lib/detail/wgl_functions.inc>
#endif

#undef NV_GL_FUN_REN
#undef NV_GL_FUN_EXT
#undef NV_GL_FUN

}

namespace nv {
/* Dynamic load support */
	bool load_gl_no_context( const char* path = NV_GL_PATH );
#	if defined( NV_GL_DYNAMIC )
		bool load_gl_library( const char* path = NV_GL_PATH );
		bool load_wgl_library( const char* path = NV_GL_PATH );
#	else
		inline bool load_gl_library( const char* path = "" ) { return true; }
		inline bool load_wgl_library( const char* path = "" ) { return true; }
#	endif
}

#endif // NV_LIB_GL_HH
