// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_names.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief GL name clasess
 */

#ifndef NV_GL_NAMES_HH
#define NV_GL_NAMES_HH

#include <nv/common.hh>

namespace nv
{

	class gl_name
	{
	public:
		gl_name() : m_value( 0 ) {}
		unsigned get_value() const { return m_value; }
		bool is_valid() const { return m_value != 0; }
	protected:
		unsigned m_value;
	};

	class gl_texture_name : public gl_name
	{
	public:
		gl_texture_name();
		~gl_texture_name();
	};

	class gl_shader_name : public gl_name
	{
	public:
		gl_shader_name();
		~gl_shader_name();
	};

	class gl_buffer_name : public gl_name
	{
	public:
		gl_buffer_name();
		~gl_buffer_name();
	};

}

#endif // NV_GL_NAMES_HH
