// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file profiler.hh
 * @author Kornel Kisielewicz
 * @brief profiler
 */

#ifndef NV_PROFILER_HH
#define NV_PROFILER_HH

#include <nv/common.hh>
#include <nv/singleton.hh>
#include <unordered_map>

#define NV_PROFILE( tag ) nv::profiler_guard __profile( tag )

namespace nv
{
	class profiler : public auto_singleton< profiler >
	{
	protected:
		class node
		{
		public:
			friend class profiler;
			node* get_parent() { return m_parent; }
			node* get_child( const std::string& tag )
			{
				auto it = m_children.find( tag );
				return ( it != m_children.end() ) ? it->second : nullptr;
			}
		protected:
			node( const char* tag, node* parent );
			node* request_child( const char* tag );
			void start();
			bool stop();
			~node();
		protected:
			typedef std::unordered_map< std::string, node* > map;

			std::string m_tag;
			map         m_children;
			node*       m_parent;
			uint32      m_recusion;

			uint32      m_calls;
			uint64      m_start_time_us;
			uint64      m_total_time_us;
		};

	protected:
		profiler();
		~profiler();

		void start_profile( const char* tag );
		void stop_profile();
	public:
		friend class auto_singleton< profiler >;
		friend class profiler_guard;
		void log_report();
	private:
		void log_node_children( const std::string& ind, const node* n );
		node* m_root;
		node* m_current;
	};

	class profiler_guard
	{
	public:
		profiler_guard( const char* tag )
		{
			profiler::pointer()->start_profile( tag );
		}

		~profiler_guard()
		{
			profiler::pointer()->stop_profile();
		}
	};

} // namespace nv

#endif // NV_PROFILER_HH
