// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LIB_SDL_IMAGE_HH
#define NV_LIB_SDL_IMAGE_HH

#include <nv/common.hh>
#include <nv/lib/sdl.hh>

#if NV_PLATFORM == NV_WINDOWS
#	define NV_SDL_IMAGE_PATH_12 "SDL_image.dll"
#	define NV_SDL_IMAGE_PATH_20 "SDL2_image.dll"
#elif NV_PLATFORM == NV_APPLE
#	define NV_SDL_IMAGE_PATH_12 "SDL_image.framework/SDL_image"
#	define NV_SDL_IMAGE_PATH_20 "SDL2_image.framework/SDL_image"
#else
#	define NV_SDL_IMAGE_PATH_12 "libSDL_image-1.2.so.0"
#	define NV_SDL_IMAGE_PATH_20 "libSDL2_image-2.0.so.0"
#endif

#if NV_SDL_VERSION == NV_SDL_12
#	define NV_SDL_IMAGE_PATH NV_SDL_IMAGE_PATH_12
#elif NV_SDL_VERSION == NV_SDL_20 
#	define NV_SDL_IMAGE_PATH NV_SDL_IMAGE_PATH_20
#elif NV_SDL_VERSION == NV_SDL_C
#	define NV_SDL_IMAGE_PATH nullptr
#else
#	error "Unrecognized NV_SDL_VERSION!"
#endif

extern "C" {

/** SDL_image defines */
#if NV_SDL_VERSION == NV_SDL_20 
#define SDL_IMAGE_MAJOR_VERSION	2
#define SDL_IMAGE_MINOR_VERSION	0
#define SDL_IMAGE_PATCHLEVEL	0
#else
#define SDL_IMAGE_MAJOR_VERSION	1
#define SDL_IMAGE_MINOR_VERSION	2
#define SDL_IMAGE_PATCHLEVEL	11
#endif

#define SDL_IMAGE_VERSION(X)						\
{									\
	(X)->major = SDL_IMAGE_MAJOR_VERSION;				\
	(X)->minor = SDL_IMAGE_MINOR_VERSION;				\
	(X)->patch = SDL_IMAGE_PATCHLEVEL;				\
}
typedef enum
{
    IMG_INIT_JPG = 0x00000001,
    IMG_INIT_PNG = 0x00000002,
    IMG_INIT_TIF = 0x00000004,
} IMG_InitFlags;

#if defined(NV_SDL_DYNAMIC)
#	define NV_SDL_FUN( rtype, fname, fparams ) NV_SDL_API rtype (NV_SDL_APIENTRY *fname) fparams
#else
#	define NV_SDL_FUN( rtype, fname, fparams ) NV_SDL_API rtype NV_SDL_APIENTRY fname fparams
#endif
#include <nv/lib/detail/sdl_image_functions.inc>
#undef NV_SDL_FUN

}

namespace nv {
/* Dynamic load support */
#	if defined( NV_SDL_DYNAMIC )
		bool load_sdl_image_library( const char* path = NV_SDL_IMAGE_PATH );
#	else
		inline bool load_sdl_image_library( const char* path = "" ) { return true; }
#	endif
}

#endif // NV_LIB_SDL_IMAGE_HH
