// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

// WARNING: this file is explicitly designed to fuck with your brain

#ifndef NV_VERTEX_HH
#define NV_VERTEX_HH

#include <nv/common.hh>
#include <nv/math.hh>

namespace nv
{

	enum slot
	{
		POSITION       = 0,
		TEXCOORD       = 1,
		NORMAL         = 2,
		TANGENT        = 3,
		BONEINDEX      = 4,
		BONEWEIGHT     = 5,
		COLOR          = 6,

		SLOT_MAX       = 6,
		SLOT_MAX_STORE = 8,
	};

// 	struct vertex_descriptor
// 	{
// 		static const datatype position_etype   = NONE;
// 		static const datatype normal_etype     = NONE;
// 		static const datatype texcoord_etype   = NONE;
// 		static const datatype tangent_etype    = NONE;
// 		static const datatype boneindex_etype  = NONE;
// 		static const datatype boneweight_etype = NONE;
// 		static const datatype color_etype      = NONE;
// 	};
// 
// 	template < typename VD >
// 	struct vertex_type 
// 		: public VD
// 
// 	{
// 		typedef typename enum_to_type< VD::position_etype >::type    position_type;
// 		typedef typename enum_to_type< VD::normal_etype >::type      normal_type;
// 		typedef typename enum_to_type< VD::texcoord_etype >::type    texcoord_type;
// 		typedef typename enum_to_type< VD::tangent_etype >::type     tangent_type;
// 		typedef typename enum_to_type< VD::boneindex_etype >::type   boneindex_type;
// 		typedef typename enum_to_type< VD::boneweight_etype >::type  boneweight_type;
// 		typedef typename enum_to_type< VD::color_etype >::type       color_type;
// 	};

	namespace detail
	{

		template < typename VT, slot SLOT >
		struct vertex_has_slot_impl
		{
			static bool const value = false;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, POSITION >
		{
		private:
			struct fallback { int position; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::position>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, NORMAL >
		{
		private:
			struct fallback { int normal; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::normal>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, TEXCOORD >
		{
		private:
			struct fallback { int texcoord; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::texcoord>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, TANGENT >
		{
		private:
			struct fallback { int tangent; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::tangent>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, BONEINDEX >
		{
		private:
			struct fallback { int boneindex; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::boneindex>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, BONEWEIGHT >
		{
		private:
			struct fallback { int boneweight; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::boneweight>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT >
		struct vertex_has_slot_impl< VT, COLOR >
		{
		private:
			struct fallback { int color; };
			struct derived : VT, fallback { };
			template<typename C, C> struct cht; 
			template<typename C> static char (&test(cht<int fallback::*, &C::color>*))[1]; 
			template<typename C> static char (&test(...))[2]; 
		public:
			static bool const value = sizeof(test<derived>(0)) == 2;
		};

		template < typename VT, slot SLOT, bool HAS_SLOT >
		struct vertex_slot_info_impl
		{
		};

		template < typename VT, slot SLOT >
		struct vertex_slot_info_impl < VT, SLOT, false >
		{
			typedef empty_type value_type;
			static const datatype etype  = datatype::NONE;
			static const int      offset = 0;
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, POSITION, true >
		{
			typedef decltype( VT::position ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::position ) >::type;
			static const int      offset = offsetof( VT, position );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, TEXCOORD, true >
		{
			typedef decltype( VT::texcoord ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::texcoord ) >::type;
			static const int      offset = offsetof( VT, texcoord );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, NORMAL, true >
		{
			typedef decltype( VT::normal ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::normal ) >::type;
			static const int      offset = offsetof( VT, normal );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, TANGENT, true >
		{
			typedef decltype( VT::tangent ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::tangent ) >::type;
			static const int      offset = offsetof( VT, tangent );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, BONEINDEX, true >
		{
			typedef decltype( VT::boneindex ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::boneindex ) >::type;
			static const int      offset = offsetof( VT, boneindex );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, BONEWEIGHT, true >
		{
			typedef decltype( VT::boneweight ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::boneweight ) >::type;
			static const int      offset = offsetof( VT, boneweight );
		};

		template < typename VT >
		struct vertex_slot_info_impl< VT, COLOR, true >
		{
			typedef decltype( VT::color ) value_type;
			static const datatype etype  = type_to_enum< decltype( VT::color ) >::type;
			static const int      offset = offsetof( VT, color );
		};
	
	}

	template < typename VT, slot SLOT >
	struct vertex_has_slot : public detail::vertex_has_slot_impl< VT, SLOT >
	{
	};


	template < typename VT, slot SLOT >
	struct vertex_slot_info : public detail::vertex_slot_info_impl< VT, SLOT, detail::vertex_has_slot_impl< VT, SLOT >::value >
	{
	};

	struct vertex_descriptor_slot
	{
		datatype etype;
		uint32   offset;
		slot     vslot;
	};

	struct vertex_descriptor
	{
		vertex_descriptor_slot slots[ SLOT_MAX_STORE ];
		uint32                 count;
		uint32                 size;

		template < typename VTX >
		void initialize()
		{
			count = 0;
			initialize_slot< VTX, slot::POSITION >();
			initialize_slot< VTX, slot::TEXCOORD >();
			initialize_slot< VTX, slot::NORMAL >();
			initialize_slot< VTX, slot::TANGENT >();
			initialize_slot< VTX, slot::BONEINDEX >();
			initialize_slot< VTX, slot::BONEWEIGHT >();
			initialize_slot< VTX, slot::COLOR >();
			size = sizeof( VTX );
		}
	private:
		template < typename VTX, slot SLOT >
		void initialize_slot()
		{
			typedef vertex_slot_info< VTX, SLOT > slot_info;
			slots[ count ].etype  = slot_info::etype;
			if ( slots[ count ].etype != datatype::NONE )
			{
				slots[ count ].vslot  = SLOT;
				slots[ count ].offset = slot_info::offset;
				count++;
			}
		}

	};

}

#endif // NV_VERTEX_HH
