// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_SKELETAL_MESH_HH
#define NV_SKELETAL_MESH_HH

#include <nv/common.hh>
#include <nv/interface/context.hh>
#include <nv/interface/animated_mesh.hh>
#include <nv/formats/md5_loader.hh>

namespace nv
{

	class skeletal_animation_entry : public animation_entry
	{
	public:
		friend class skeletal_mesh;

		skeletal_animation_entry( const std::string& name, md5_animation* a_animation, bool a_looping ) 
			: animation_entry( name ), m_animation( a_animation ), m_looping( a_looping ) {}
		virtual uint32 get_frame_rate() const { return m_animation->get_frame_rate(); }
		virtual uint32 get_frame_count() const { return m_animation->get_frame_count(); }
		virtual bool is_looping() const { return m_looping; }
	protected:
		md5_animation* m_animation;
		bool           m_looping;
	};

	// TODO: INSTANCING! currently md5_mesh data is deleted!
	class skeletal_mesh : public animated_mesh
	{
	public:
		skeletal_mesh( context* a_context, md5_mesh_data* a_mesh_data );
		virtual size_t get_index_count() const { return m_mesh_data->get_index_count(); }
		virtual void run_animation( animation_entry* a_anim );
		virtual void setup_animation( md5_animation* a_anim );
		virtual void update( uint32 ms );
		virtual ~skeletal_mesh();
	protected:
		md5_mesh_instance* m_mesh_data;
		md5_animation*     m_animation;

		std::vector< transform > m_transform;
		uint32                   m_animation_time;
	};

} // namespace nv

#endif // NV_SKELETAL_MESH_HH
