// Copyright (C) 2014 ChaosForge Ltd 
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_LUA_OBJECT_HH
#define NV_LUA_OBJECT_HH

#include <nv/common.hh>
#include <nv/lua/lua_values.hh>
#include <nv/object.hh>

namespace nv
{

	namespace lua
	{

		namespace detail
		{

			template <typename T>
			struct type_degrade< T*, typename std::enable_if< std::is_base_of<object, T >::value >::type >
			{
				typedef object* type;
			};

			void  push_object  ( lua_State *L, object* o );
			void* to_object  ( lua_State *L, int index );
			void* to_object  ( lua_State *L, int index, void* def );

		}

		template <>
		struct pass_traits<object*>
		{
			static void push( lua_State *L, object* o ) { detail::push_object( L, o ); }
			static object* to( lua_State *L, int index ) { return static_cast< object* >( detail::to_ref_object( L, index ) ); }
			static object* to( lua_State *L, int index, object* def ) { return static_cast< object* >( detail::to_ref_object( L, index, def ) ); }
		};

	}
}

#endif // NV_LUA_OBJECT_HH
