// Copyright (C) 2012 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_ROOT_HH
#define NV_ROOT_HH

#include <nv/common.hh>
#include <nv/object.hh>
#include <nv/string.hh>
#include <list>

namespace nv
{
	/**
	 * Implements the root of a object tree-like structure.
	 */
	class root : public object
	{
	public:
		root() : object( "" ), m_lua_state( nullptr ), m_uid_store( nullptr ) {}
		lua::state*    get_lua_state()     const { return m_lua_state; }
		uid_store*     get_uid_store()     const { return m_uid_store; }
		template < typename T >
		object* create_object( const std::string& id )
		{
			object* o = new T(id);
			object_created(o);
			return o;
		}
		void register_with_lua( object* o, const char* lua_name, const char* storage );
		void destroy_children( object* o );
		virtual void destroy_object( object* o );
		virtual ~root() { destroy_object( this ); }
	protected:
		virtual void object_created( object* o );

		lua::state*    m_lua_state;
		uid_store*     m_uid_store; 
	};

} // namespace nv

#endif // NV_ROOT_HH
