// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include <nv/resource_manager.hh>

using namespace nv;

resource_manager::resource_manager()
{

}

resource* resource_manager::get_raw_resource(uint32 id) const
{
	return m_data[ id ];
}

resource* resource_manager::get_raw_resource(const std::string& id) const
{
	auto i = m_id_map.find( id );
	if ( i != m_id_map.end() )
	{
		return m_data[ (unsigned int)i->second ];
	}
	return nullptr;
}

void resource_manager::register_resource_type( const std::string& type_name, resource_constructor_func c )
{
	m_constructors[ type_name ] = c;
}

resource_manager::~resource_manager()
{

}
