// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gui/gui_environment.hh"

#include "nv/gui/gui_renderer.hh"


	/*

	TODO: parse a lua stylesheet as per Trac wiki

	IDEA: Store everything in std::unordered_maps, with lua_value's?

	A lua_value is a variant stores strings as const char* that deletes them on destructor?
	Question is that there might not be much gained on speed anyway, due to Lua's speed.
	Special function field allows delayed per parse execution?

	*/

#include "nv/gfx/sliced_buffer.hh"
#include "nv/gfx/texture_atlas.hh"

#include <vector>

using namespace nv;
using namespace nv::gui;

environment::environment( window* w, const std::string& shader_path )
	: m_renderer( nullptr ), m_window( w ), m_screen( nullptr )
{
	m_area.dim( dimension( w->get_width(), w->get_height() ) );
	m_screen = new screen( m_area );
	m_renderer = new renderer( w, shader_path );
	root::add_child( m_screen );
}

void nv::gui::environment::load_style( const std::string& filename )
{
	m_renderer->load_style( filename );
}

element* nv::gui::environment::create_element( element* parent, const rectangle& r )
{
	element* result = new element( r );
	object_created( result );
	if ( parent == nullptr ) parent = m_screen;
	parent->add_child( result );
	return result;
}

void environment::update( element* e, uint32 elapsed )
{
	e->on_update( elapsed );
	if ( e->is_visible() )
	{
		for ( object* i : *e )
		{
			update( ((element*)i), elapsed );
		}
	}
	if ( e->is_dirty() || e->m_render_data == nullptr )
	{
		m_renderer->redraw( e, elapsed );
		e->set_dirty( false );
	}
}

void environment::draw( element* e )
{
	if ( e->is_visible() )
	{
		e->on_draw();
		m_renderer->draw( e );
		for ( object* i : *e )
		{
			draw((element*)i);
		}
	}
}

void environment::update()
{
	update( m_screen, 0 );
}

void environment::draw()
{
	draw( m_screen );
	m_renderer->draw();
}

void environment::add_child( object* child )
{
	// TODO: check if element
	m_screen->add_child( child );
}

environment::~environment()
{
	destroy_children( this );
	delete m_renderer;
}

