// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file resource_manager.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 */

#ifndef NV_RESOURCE_MANAGER_HH
#define NV_RESOURCE_MANAGER_HH

#include <nv/resource.hh>
#include <nv/singleton.hh>
#include <string>
#include <unordered_map>
#include <vector>

namespace nv
{
	typedef std::shared_ptr<resource> (*resource_constructor_func)();

	template <typename TYPE> 
	std::shared_ptr<resource> resource_constructor()
	{
		return std::static_pointer_cast<resource>( std::shared_ptr<TYPE>( new TYPE() ) );
	}


	class resource_manager : public auto_singleton< resource_manager >
	{
	public:
		resource_manager();
		~resource_manager();

		template<typename T>
		void register_resource_type( const std::string& name )
		{
			register_resource_type( name, resource_constructor<T> );
		}
		void register_resource_type( const std::string& name, resource_constructor_func c );

		template<typename T>
		std::shared_ptr<T> get_resource(uint32 id) const
		{
			auto result = std::dynamic_pointer_cast<T,resource>( get_raw_resource( id ) );
			return result;
		}
		template<typename T>
		std::shared_ptr<T> get_resource( const std::string& id ) const
		{
			auto result = std::dynamic_pointer_cast<T,resource>( get_raw_resource( id ) );
			return result;
		}

		resource* get_raw_resource(uint32 id) const;
		resource* get_raw_resource(const std::string& id) const;
		
	private:
		typedef std::vector< resource* > resources; 
		typedef std::unordered_map< std::string, uid > id_map;
		typedef std::unordered_map< std::string, resource_constructor_func > constructor_map;

	private:
		resources       m_data;
		id_map          m_id_map;
		constructor_map m_constructors;
	};

}

#endif // NV_RESOURCE_MANAGER_HH
