// Copyright (C) 2014 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file scene_node.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Scene node class
 */

#ifndef NV_SCENE_NODE_HH
#define NV_SCENE_NODE_HH

#include <nv/common.hh>
#include <vector>
#include <nv/transform.hh>
#include <nv/math.hh>
#include <nv/interface/render_state.hh>

namespace nv
{

	class scene_node
	{
	public:
		typedef std::vector< scene_node* > list;
		
		scene_node() {}

		virtual void update( uint32 ms )
		{
			for ( auto& child : m_children )
			{
				child->update( ms );
			}
		}

		virtual void attach( scene_node* child )
		{
			m_children.push_back( child );
		}

		virtual void set_transform( const transform& t )
		{
			m_transform = t;
		}

		virtual const transform& get_transform() const
		{
			return m_transform;
		}

		virtual mat4 extract_transform_matrix() const
		{
			return get_transform().extract();
		}

		const vec3& get_position() const 
		{ 
			return m_transform.get_position(); 
		}

		const quat& get_orientation() const 
		{ 
			return m_transform.get_orientation(); 
		}


		list::const_iterator begin() { return m_children.cbegin(); }
		list::const_iterator end()   { return m_children.cend(); }

		virtual ~scene_node()
		{
			for ( auto& child : m_children ) delete child;
		}

	protected:
		transform m_transform;
		list      m_children;
	};

}

#endif // NV_SCENE_NODE_HH
