// Copyright (C) 2012-2014 ChaosForge Ltd
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/root.hh"

#include "nv/uid.hh"
#include "nv/lua/lua_state.hh"

void nv::root::object_created( object* o )
{
	if ( m_uid_store )
	{
		o->m_uid = m_uid_store->insert( o );
	}
}

void nv::root::object_destroyed( object* o )
{
	if ( m_lua_state && o->m_lua_index != lua::ref_none )
	{
		m_lua_state->unregister_object( o );
	}
	if ( m_uid_store && o->m_uid != 0 )
	{
		m_uid_store->remove( o->m_uid );
	}
}
