// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gui/gui_style.hh"

#include <nv/lua/lua_raw.hh>

using namespace nv;
using namespace nv::gui;

style::style()
{
}

void style::load_style( const std::string& filename )
{
	m_lua.do_file( filename );
}

bool style::get( element* e, const std::string& entry, std::string& s )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e, entry, LUA_TSTRING ) ) return false;
	s = lua_tostring( m_lua, -1 );
	return true;
}

bool style::get( element* e, const std::string& entry, vec4& vec )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e, entry, LUA_TTABLE ) ) return false;
	vec = vec4();
	for (size_t i = 0; i < 4; ++i )
	{
		lua_rawgeti( m_lua, -1, static_cast<int>( i+1 ) );
		if ( lua_isnil( m_lua, -1 ) ) return true;
		vec[i] = (float)lua_tonumber( m_lua, -1 );
		lua_pop( m_lua, 1 );
	}
	return true;
}

bool style::get( element* e, const std::string& entry, int& i )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e, entry, LUA_TNUMBER ) ) return false;
	i = static_cast< int >( lua_tointeger( m_lua, -1 ) );
	return true;
}

bool style::get( element* e, const std::string& entry, double& d )
{
	lua::stack_guard guard( m_lua );
	if ( !resolve( e, entry, LUA_TNUMBER ) ) return false;
	d = lua_tonumber( m_lua, -1 );
	return true;
}

style::~style()
{
}

bool style::resolve( element* e, const std::string& entry, int type )
{
	const char* centry = entry.c_str();
	const char* cid    = e->get_id().c_str();
	const char* cclass = e->get_class().c_str();
	lua_getglobal( m_lua, "default" );
	int global = lua_gettop( m_lua );

	// check id
	lua_getfield( m_lua, -1, cid );
	if ( lua_istable( m_lua, -1 ) )
	{
		lua_getfield( m_lua, -1, centry );
		if ( lua_type( m_lua, -1 ) == type ) return true;
	}
	lua_settop( m_lua, global );

	// check class
	lua_getfield( m_lua, -1, cclass );
	if ( lua_istable( m_lua, -1 ) )
	{
		lua_getfield( m_lua, -1, centry );
		if ( lua_type( m_lua, -1 ) == type ) return true;
	}
	lua_settop( m_lua, global );

	// check entry
	lua_getfield( m_lua, -1, centry );
	if ( lua_type( m_lua, -1 ) == type ) return true;
	return false;
}
