#version 120

attribute vec2 nv_texcoord;
attribute vec3 nv_position;
attribute vec3 nv_normal;
attribute vec3 nv_next_position;
attribute vec3 nv_next_normal;

varying vec3 v_normal;
varying vec3 v_light_vector;
varying vec3 v_view_vector;
varying vec2 v_texcoord;

uniform mat4 nv_m_mvp;
uniform mat4 nv_m_model;
uniform mat4 nv_m_model_inv;
uniform vec3 nv_v_camera_position;
uniform vec3 light_position;
uniform float nv_interpolate;

void main(void)
{
	vec4 position   = vec4( mix( nv_position, nv_next_position, nv_interpolate ), 1.0 );
	v_normal        = normalize( mix( nv_normal, nv_next_normal, nv_interpolate ) );
	v_texcoord      = nv_texcoord;
	gl_Position     = nv_m_mvp * position;

	vec3 camera_loc = vec3(nv_m_model_inv * vec4 (nv_v_camera_position, 1.0) );
	vec3 light_loc  = vec3(nv_m_model_inv * vec4 (light_position, 1.0) );

	v_view_vector  = normalize( nv_position - camera_loc  );
	v_light_vector = normalize( nv_position - light_loc );
}
