// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_vertex_buffer.hh"

#include "nv/lib/gl.hh"
#include "nv/gl/gl_enum.hh"

using namespace nv;

gl_vertex_buffer::gl_vertex_buffer( buffer_hint hint, size_t size, const void* data ) 
	: vertex_buffer( hint, size ), m_name()
{
	bind();
	glBufferData( GL_ARRAY_BUFFER, (GLsizeiptr)m_size, data, buffer_hint_to_enum( m_hint ) );
	unbind();
}

void gl_vertex_buffer::update( const void* data, size_t offset, size_t size )
{
	// IMPORTANT - THIS DOES NOT BIND, SHOULD IT?
	glBufferSubData( GL_ARRAY_BUFFER, (GLintptr)offset, (GLsizeiptr)size, data );
}


void gl_vertex_buffer::bind()
{
	glBindBuffer( GL_ARRAY_BUFFER, m_name.get_value() );
}

void gl_vertex_buffer::unbind()
{
	glBindBuffer( GL_ARRAY_BUFFER, 0 );
}

bool gl_vertex_buffer::is_valid() const
{
	return m_name.is_valid();
}

gl_index_buffer::gl_index_buffer( buffer_hint hint, size_t size, const void* data ) 
	: index_buffer( hint, size ), m_name()
{
	bind();
	glBufferData( GL_ELEMENT_ARRAY_BUFFER, (GLsizeiptr)m_size, data, buffer_hint_to_enum( m_hint ) );
	unbind();
}

void gl_index_buffer::update( const void* data, size_t offset, size_t size )
{
	glBufferSubData( GL_ELEMENT_ARRAY_BUFFER, (GLintptr)offset, (GLsizeiptr)size, data );
}

void gl_index_buffer::bind()
{
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, m_name.get_value() );
}

void gl_index_buffer::unbind()
{
	glBindBuffer( GL_ELEMENT_ARRAY_BUFFER, 0 );
}

bool gl_index_buffer::is_valid() const
{
	return m_name.is_valid();
}

gl_vertex_array::gl_vertex_array()
{

}

void gl_vertex_array::bind()
{
	for ( vertex_buffer_attribute_map::iterator i = m_map.begin(); 	i != m_map.end(); ++i ) 
	{
		uint32 location             = static_cast<uint32>( i->first );
		vertex_buffer_attribute* va = i->second;
		vertex_buffer*           vb = va->get_buffer();
		glEnableVertexAttribArray( location );
		vb->bind();
		glVertexAttribPointer( 
			location, 
			static_cast<GLint>( va->get_components() ), 
			nv::datatype_to_gl_enum( va->get_datatype() ),
			GL_FALSE,
			static_cast<GLsizei>( va->get_stride() ),
			(void*)va->get_offset()
			);
		vb->unbind();
	}

	if ( m_index )
	{
		m_index->bind();
	}
}

void gl_vertex_array::unbind()
{
	if ( m_index )
	{
		m_index->unbind();
	}

	for ( vertex_buffer_attribute_map::iterator i = m_map.begin(); 	i != m_map.end(); ++i ) 
	{
		glDisableVertexAttribArray( static_cast<uint32>( i->first ) );
	}
}
