// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file resource.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief resource implementation
 */

#ifndef NV_RESOURCE_HH
#define NV_RESOURCE_HH

#include <nv/common.hh>
#include <memory>

namespace nv
{

	class resource
	{
	public:
		resource() : m_size(0), m_rid(0), m_used(0), m_loaded(0), m_data(nullptr) {}
		virtual bool load() = 0;
		virtual bool initialize() { return true; };
		virtual bool destroy() { return true; };
		virtual bool unload() = 0;
		bool is_loaded() const { return m_loaded; }
		uid get_rid() const { return m_rid; }
		uid get_size() const { return m_size; }
		const void* get() { return m_data; }
		void lock() { m_used++; }
		void unlock() { m_used--; }
		virtual ~resource() {}
	private:
		uint32 m_size;
		uint32 m_rid;
		uint32 m_used;
		bool   m_loaded;
		void*  m_data;
	};

	template< class DATA >
	class resource_type : public resource
	{
	public:
		explicit resource_type( DATA* data ) : m_data( data ) {}
		virtual bool load() { return true; };
		virtual bool unload() { return true; };
		~resource_type() { delete data; }
	};



	template< class DATA >
	class resource_handle
	{
	public:
		explicit resource_handle( resource_type< DATA >& m_resource ) 
			: m_resource( &a_resource ) { m_resource.lock(); }
		void assign( resource_type< DATA >& a_resource ) 
		{
			m_resource.unlock();
			m_resource = a_resource;
			m_resource.lock();
		}
		const DATA* operator->() const { return (const DATA*)m_resource.get(); }
		~resource_handle() { m_resource.unlock(); }
	private:
		resource& m_resource;
	};

}

#endif // NV_RESOURCE_HH
