// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_MESH_LOADER_HH
#define NV_MESH_LOADER_HH

#include <nv/common.hh>
#include <vector>
#include <unordered_map>
#include <nv/transform.hh>
#include <nv/string.hh>
#include <nv/gfx/animation.hh>
#include <nv/interface/mesh_data.hh>
#include <nv/interface/stream.hh>

namespace nv 
{

	class tag_map
	{
	public:
		typedef std::unordered_map< std::string, transform_vector > map;

		tag_map () {}
		map& get_map()             { return m_map; }
		const map& get_map() const { return m_map; }
		const transform_vector* get_tag( const std::string& key ) const
		{
			auto it = m_map.find( key );
			return ( it != m_map.end() ? &(it->second) : nullptr );
		}
	private:
		map m_map;
	};


	class mesh_loader
	{
	public:
		mesh_loader() {}
		virtual ~mesh_loader() {}
		virtual tag_map* create_tag_map() { return nullptr; }
		virtual bool load( stream& source ) = 0;
		virtual mesh_data* release_mesh_data( size_t index = 0 ) = 0;
		virtual size_t get_mesh_count() const = 0;
	};

}

#endif // NV_MESH_LOADER_HH

