// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file audio.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Audio interface class
 */

#ifndef NV_AUDIO_HH
#define NV_AUDIO_HH

#include <nv/common.hh>
#include <nv/math.hh>

namespace nv
{
	class sound
	{
	public:
		virtual ~sound() {}
	};

	class channel
	{
	public:
		virtual ~channel() {}
	};

	class audio
	{
	public:
		virtual channel* play_sound( sound* a_sound ) = 0;
		virtual sound* load_sound( const std::string& a_path ) = 0;
		virtual void update() {}
		virtual ~audio() {}
	};
}

#endif // NV_AUDIO_HH
