// Copyright (C) 2014 ChaosForge Ltd 
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/assimp.hh"

nv::assimp_log_guard::assimp_log_guard()
{
	aiLogStream ls = aiGetPredefinedLogStream( aiDefaultLogStream_FILE, "assimp_log.txt" );
	aiAttachLogStream(&ls);
	ls.callback = assimp_log_callback;
	ls.user     = nullptr;
	aiAttachLogStream(&ls);
}

nv::assimp_log_guard::~assimp_log_guard()
{
	aiDetachAllLogStreams();
}

#if defined( NV_ASSIMP_DYNAMIC )

#include "nv/library.hh"

#define NV_ASSIMP_FUN( rtype, fname, fparams ) rtype (NV_ASSIMP_APIENTRY *fname) fparams = nullptr;
#include <nv/lib/detail/assimp_functions.inc>
#undef NV_ASSIMP_FUN

bool nv::load_assimp_library( const char* path )
{
	static nv::library assimp_library;
	if ( assimp_library.is_open() ) return true;
	assimp_library.open( path );

#	define NV_ASSIMP_FUN( rtype, fname, fparams ) *(void **) (&fname) = assimp_library.get(#fname);
#	include <nv/lib/detail/assimp_functions.inc>
#	undef NV_ASSIMP_FUN

	return true;
}
#endif
