// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
//
// TODO: the calls are supported only up to 4 parameters because:
//    -- if you have more than 4 params, you're doing something wrong
//    -- once the Variadic Templates cometh, for great justice we will win!
//
// TODO: this is a job for std::forward, but I'll take care of it later

#ifndef NV_LUA_DISPATCH_HH
#define NV_LUA_DISPATCH_HH

#include <nv/common.hh>
#include <nv/string.hh>
#include <nv/lua/lua_values.hh>
#include <nv/lua/lua_path.hh>

//struct lua_State;

namespace nv
{
	namespace lua
	{
		typedef int (__cdecl *lfunction) (struct lua_State *L);

		namespace detail
		{
			template < typename R >
			struct dispatcher
			{
				static int call( lua_State* L, int, R (*func)() )
				{
					push_value( L, func() ); return 1;
				}
				template < typename T1 >
				static int call( lua_State* L, int index, R (*func)( T1 ) )
				{
					push_value( L, func( get_value<T1>( L, index + 0 ) ) ); return 1;
				}
				template < typename T1, typename T2 >
				static int call( lua_State* L, int index, R (*func)( T1, T2 ) )
				{
					push_value( L, func( get_value<T1>( L, index + 0 ),	get_value<T2>( L, index + 1 ) ) ); return 1;
				}
				template < typename T1, typename T2, typename T3 >
				static int call( lua_State* L, int index, R (*func)( T1, T2, T3 ) )
				{
					push_value( L, func( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ) ) ); return 1;
				}
				template < typename T1, typename T2, typename T3, typename T4 >
				static int call( lua_State* L, int index, R (*func)( T1, T2, T3, T4 ) )
				{
					push_value( L, func( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ), get_value<T4>( L, index + 3 ) ) ); return 1;
				}
				template < class C >
				static int call( lua_State* L, int, C& c, R (C::*func)() )
				{
					push_value( L, (c.*func)() ); return 1;
				}
				template < class C, typename T1 >
				static int call( lua_State* L, int index, C& c, R (C::*func)( T1 ) )
				{
					push_value( L, (c.*func)( get_value<T1>( L, index + 0 ) ) ); return 1;
				}
				template < class C, typename T1, typename T2 >
				static int call( lua_State* L, int index, C& c, R (C::*func)( T1, T2 ) )
				{
					push_value( L, (c.*func)( get_value<T1>( L, index + 0 ),	get_value<T2>( L, index + 1 ) ) ); return 1;
				}
				template < class C, typename T1, typename T2, typename T3 >
				static int call( lua_State* L, int index, C& c, R (C::*func)( T1, T2, T3 ) )
				{
					push_value( L, (c.*func)( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ) ) ); return 1;
				}
				template < class C, typename T1, typename T2, typename T3, typename T4 >
				static int call( lua_State* L, int index, C& c, R (C::*func)( T1, T2, T3, T4 ) )
				{
					push_value( L, (c.*func)( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ), get_value<T4>( L, index + 3 ) ) ); return 1;
				}
			};
			
			template <>
			struct dispatcher< void >
			{
				static int call( lua_State*, int, void (*func)() )
				{
					func(); return 0;
				}
				template < typename T1 >
				static int call( lua_State* L, int index, void (*func)( T1 ) )
				{
					func( get_value<T1>( L, index + 0 ) ); return 0;
				}
				template < typename T1, typename T2 >
				static int call( lua_State* L, int index, void (*func)( T1, T2 ) )
				{
					func( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ) ); return 0;
				}
				template < typename T1, typename T2, typename T3 >
				static int call( lua_State* L, int index, void (*func)( T1, T2, T3 ) )
				{
					func( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ) ); return 0;
				}
				template < typename T1, typename T2, typename T3, typename T4 >
				static int call( lua_State* L, int index, void (*func)( T1, T2, T3, T4 ) )
				{
					func( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ), get_value<T4>( L, index + 3 ) ); return 0;
				}
				template < class C >
				static int call( lua_State*, int, C& c, void (C::*func)() )
				{
					(c.*func)(); return 0;
				}
				template < class C, typename T1 >
				static int call( lua_State* L, int index, C& c, void (C::*func)( T1 ) )
				{
					(c.*func)( get_value<T1>( L, index + 0 ) ); return 0;
				}
				template < class C, typename T1, typename T2 >
				static int call( lua_State* L, int index, C& c, void (C::*func)( T1, T2 ) )
				{
					(c.*func)( get_value<T1>( L, index + 0 ),	get_value<T2>( L, index + 1 ) ); return 0;
				}
				template < class C, typename T1, typename T2, typename T3 >
				static int call( lua_State* L, int index, C& c, void (C::*func)( T1, T2, T3 ) )
				{
					(c.*func)( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ) ); return 0;
				}
				template < class C, typename T1, typename T2, typename T3, typename T4 >
				static int call( lua_State* L, int index, C& c, void (C::*func)( T1, T2, T3, T4 ) )
				{
					(c.*func)( get_value<T1>( L, index + 0 ), get_value<T2>( L, index + 1 ), get_value<T3>( L, index + 2 ), get_value<T4>( L, index + 3 ) ); return 0;
				}

			};

			template < typename F, F* f > 
			int function_wrapper( lua_State* L ) 
			{
				return dispatcher<typename return_type<F>::type>::call( L, 1, f );
			}

			template < typename C, typename F, F* f > 
			int object_method_wrapper( lua_State* L ) 
			{
				C* c = to_object( L, 1 );
				return dispatcher<typename return_type<F>::type>::call( L, c, 2, f );
			}

			template < typename C, typename F, F* f > 
			int fixed_method_wrapper( lua_State* L ) 
			{
				C* c = (C*)to_pointer( L, nv::lua::detail::upvalue_index(1) );
				return dispatcher<typename return_type<F>::type>::call( L, c, 1, f );
			}
			
			template< typename F >
			int call( lua_State* L, int index, F func )
			{
				return dispatcher<typename return_type<F>::type>::call( L, index, func );
			}

			template< class C, typename F >
			int call( lua_State* L, int index, C& c, F func )
			{
				return dispatcher<typename return_type<F>::type>::call( L, index, c, func );
			}

		}

	}

}

#endif // NV_LUA_DISPATCH_HH