// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_OBJ_LOADER_HH
#define NV_OBJ_LOADER_HH

#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/interface/mesh_data.hh>

namespace nv 
{

	class obj_loader : public mesh_loader
	{
	public:
		obj_loader( bool tangents = false );
		virtual ~obj_loader();
		virtual bool load( stream& source );
		virtual size_t get_size() { return m_size; }
		virtual mesh_data_old* release_mesh_data() { mesh_data_old* m = m_mesh; m_mesh = nullptr; return m; }
	private:
		mesh_data_old*  m_mesh;
		bool            m_tangents;
		std::size_t     m_size;
	};

	class wavefront_loader 
	{
	public:
		wavefront_loader( bool normals = true, bool tangents = false );
		virtual bool load( stream& source );
		mesh_data* release_mesh_data();
		~wavefront_loader();
	private:
		vertex_descriptor m_descriptor;
		bool              m_normals;
		bool              m_tangents;
		mesh_data*        m_mesh;
	};


}

#endif // NV_OBJ_LOADER_HH
