// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file stream.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief stream interface
 */

#ifndef NV_FILE_SYSTEM_HH
#define NV_FILE_SYSTEM_HH

#include <nv/common.hh>
#include <nv/interface/stream.hh>

namespace nv
{

	class file_system
	{
	protected:
		file_system() {}
	public:
		virtual ~file_system() {}
		virtual bool exists( const char* fpath ) = 0;
		virtual stream* open( const char* fpath, const char* fmode = "rb" ) = 0;
	};

} // namespace nv

#endif // NV_FILE_SYSTEM_HH
