// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file device.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Device class
 */

#ifndef NV_DEVICE_HH
#define NV_DEVICE_HH

#include <nv/common.hh>
#include <nv/string.hh>
#include <nv/interface/mesh.hh>
#include <nv/interface/vertex_buffer.hh>
#include <nv/interface/texture2d.hh>
#include <nv/interface/image_data.hh>

namespace nv
{
	class window;
	class program;

	class device
	{
	public:
		virtual window* create_window( uint16 width, uint16 height, bool fullscreen ) = 0;
		virtual program* create_program( const string& vs_source, const string& fs_source ) = 0;
		virtual vertex_buffer* create_vertex_buffer( buffer_hint hint, size_t size, const void* source = nullptr ) = 0;
		virtual index_buffer* create_index_buffer( buffer_hint hint, size_t size, const void* source = nullptr ) = 0;
		virtual vertex_array* create_vertex_array() = 0;
		virtual image_data* create_image_data( const std::string& filename ) = 0; // temporary
		virtual texture2d* create_texture2d( ivec2 size, image_format aformat, datatype adatatype, sampler asampler, void* data = nullptr ) = 0;
		virtual uint32 get_ticks() = 0;
		virtual void delay( uint32 ms ) = 0;

		virtual vertex_array* create_vertex_array( const mesh_pack* m, const attribute_map* am, buffer_hint hint )
		{
			vertex_array* result = create_vertex_array();
			for ( auto& attr : m->get_attributes() )
			{
				// TODO : error checking
				vertex_buffer* vb = create_vertex_buffer( hint, attr.second->get_size(), attr.second->get_data() );
				result->add_vertex_buffer( am->at( attr.first )->get_location(), vb, attr.second->get_base_type(), attr.second->get_components() );
			}
			if ( m->has_indices() )
			{
				const vertex_attribute_base* i = m->get_indices();
				index_buffer* vb = create_index_buffer( hint, i->get_size(), i->get_data() );
				result->set_index_buffer( vb, i->get_base_type(), true );
			}
			return result;
		}
		virtual ~device() {}
	};

} // namespace nv


#endif // NV_DEVICE_HH
