#include <nv/gl/gl_device.hh>
#include <nv/gui/gui_environment.hh>
#include <nv/logging.hh>
#include <nv/logger.hh>
#include <cstdlib> // rand
#include <ctime> // time

class application
{
public:
	application();
	bool initialize();
	bool run();
	void kill_window();
	void spawn_window();
	void recolor_window();
	~application();
protected:
	nv::device* m_device;
	nv::window* m_window;
	nv::clear_state m_clear_state;
	nv::gui::environment* m_guienv;
	std::vector<nv::gui::element*>   m_windows;
};

application::application()
{
	m_device = new nv::gl_device();
	m_window = m_device->create_window( 800, 600, false );
	m_clear_state.buffers = nv::clear_state::COLOR_AND_DEPTH_BUFFER;
	m_guienv = new nv::gui::environment( m_window );
	m_guienv->load_style( "test.style.lua" );
}

bool application::initialize()
{
	return true;
}

bool application::run()
{
	int keypress = 0;

	while(!keypress) 
	{
		m_guienv->update();

		m_window->get_context()->clear( m_clear_state );
		m_guienv->draw();
		m_window->swap_buffers();

		nv::io_event event;
		while(m_window->poll_event(event)) 
		{      
			switch (event.type) 
			{
			case nv::EV_QUIT:
				keypress = 1;
				break;
			case nv::EV_KEY:
				if (event.key.pressed)
				{
					switch (event.key.code) 
					{
					case nv::KEY_N      : spawn_window(); break;
					case nv::KEY_K      : kill_window(); break;
					case nv::KEY_ESCAPE : keypress = 1; break;
					}
				}
				break;
			}
		}
	}
	return true;
}

void application::spawn_window()
{
	glm::ivec2 a( std::rand() % 600, std::rand() % 400 );
	glm::ivec2 b( std::rand() % 200 + 40, std::rand() % 200 + 40 );
	nv::gui::element* e = new nv::gui::element( m_guienv, nv::rectangle(a).dim(b) );
	e->set_class( "window" );
	e->set_text("Window "+nv::to_string(m_windows.size()+1) );
	m_guienv->add_child( e );
	NV_LOG( nv::LOG_INFO, "Spawn (" << a.x << "," << a.y << "x" << b.x << "," << b.y << ")" );
	m_windows.push_back( e );
}

void application::kill_window()
{
	if ( m_windows.size() == 0 ) return;
	size_t index = rand() % m_windows.size();
	delete m_windows[ index ];
	m_windows.erase( m_windows.begin() + index );
}

application::~application()
{
	m_windows.clear();
	delete m_window;
	delete m_device;
}

int main(int, char* [])
{
	std::srand((unsigned int) std::time(0) );
	nv::logger log(nv::LOG_TRACE);
	log.add_sink( new nv::log_file_sink("log.txt"), nv::LOG_TRACE );
	log.add_sink( new nv::log_console_sink(), nv::LOG_TRACE );
	
	NV_LOG( nv::LOG_NOTICE, "Logging started" );
	application app;
	if ( app.initialize() )
	{
		app.run();
	}
	NV_LOG( nv::LOG_NOTICE, "Logging stopped" );

	return 0;
}

