// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_enum.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief GL enumerations
 */

#ifndef NV_GL_ENUM_HH
#define NV_GL_ENUM_HH

#include <nv/math.hh>
#include <nv/interface/clear_state.hh>
#include <nv/interface/render_state.hh>
#include <nv/interface/vertex_buffer.hh>
#include <nv/interface/texture2d.hh>
#include <nv/interface/context.hh>

namespace nv
{

	unsigned int clear_state_buffers_to_mask( clear_state::buffers_type type );
	unsigned int depth_state_function_to_enum( depth_test::function_type type );
	unsigned int blending_factor_to_enum( blending::factor type );
	unsigned int blending_equation_to_enum( blending::equation type );
	unsigned int culling_face_type_to_enum( culling::face_type type );
	unsigned int culling_order_type_to_enum( culling::order_type type );
	unsigned int stencil_function_to_enum( stencil_test_face::function_type type );
	unsigned int stencil_operation_to_enum( stencil_test_face::operation type );
	unsigned int buffer_hint_to_enum( buffer_hint hint );
	unsigned int image_format_to_enum( image_format format );
	unsigned int sampler_filter_to_enum( sampler::filter filter );
	unsigned int sampler_wrap_to_enum( sampler::wrap wrap );
	unsigned int primitive_to_enum( primitive p );

	unsigned int datatype_to_gl_enum( datatype type );
	datatype gl_enum_to_datatype( unsigned int gl_enum );

} // namespace nv

#endif // NV_GL_ENUM_HH
