// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file type_traits.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief type traits
 */
// TODO: function_traits support only up to 4 parameters because:
//    -- if you have more than 4 params, you're doing something wrong
//    -- once the Variadic Templates cometh, for great justice we will win!

#ifndef NV_TYPE_TRAITS_HH
#define NV_TYPE_TRAITS_HH

#include <nv/common.hh>
#include <type_traits>

namespace nv
{

	// These could be done much better
	template <typename T>
	struct is_cstring
		: public std::integral_constant<bool,
		std::is_same<       char *, typename std::decay< T >::type >::value ||
		std::is_same< const char *, typename std::decay< T >::type >::value >
		{};

	template <typename T>
	struct is_stdstring
		: public std::integral_constant<bool,
		std::is_same< std::string, typename std::decay< T >::type >::value 
		>
	{};

	template < typename T > struct is_string : public std::integral_constant<bool, is_stdstring<T>::value || is_cstring<T>::value> {};

	// Just for once, MSVC is the good guy, and everybody else sucks.
	// Remove, once requiring standard-compliant CLANG/GCC versions.
#if NV_COMPILER == NV_MSVC
	using std::underlying_type;
#elif NV_COMPILER == NV_CLANG
	template < typename T >
	struct underlying_type
	{
		typedef __underlying_type(T) type;
	};
#else
	template< typename T >
	struct underlying_type
	{
		typedef typename std::conditional<
			T( -1 ) < T( 0 ),
			typename std::make_signed< T >::type,
			typename std::make_unsigned< T >::type
			>::type type;
	};
#endif

	namespace detail
	{

		template < typename F >
		struct function_traits_impl
		{

		};

		template < typename R >
		struct function_traits_impl< R (*)(void) >
		{
			typedef R (*type)();
			typedef R        return_type;
			typedef void     class_type;
			static const int arg_count = 0;
		};

		template < typename R, typename T1 >
		struct function_traits_impl< R (*)( T1 ) >
		{
			typedef R (*type)();
			typedef R        return_type;
			typedef void     class_type;
			static const int arg_count = 1;
		};

		template < typename R, typename T1, typename T2 >
		struct function_traits_impl< R (*)( T1, T2 ) >
		{
			typedef R (*type)();
			typedef R        return_type;
			typedef void     class_type;
			static const int arg_count = 2;
		};

		template < typename R, typename T1, typename T2, typename T3 >
		struct function_traits_impl< R (*)( T1, T2, T3 ) >
		{
			typedef R (*type)();
			typedef R        return_type;
			typedef void     class_type;
			static const int arg_count = 3;
		};

		template < typename R, typename T1, typename T2, typename T3, typename T4 >
		struct function_traits_impl< R (*)( T1, T2, T3, T4 ) >
		{
			typedef R (*type)();
			typedef R        return_type;
			typedef void     class_type;
			static const int arg_count = 4;
		};

		template < class C, typename R >
		struct function_traits_impl< R (C::*)() >
		{
			typedef R (*type)();
			typedef R       return_type;
			typedef C       class_type;
			static const int arg_count = 0;
		};

		template < class C, typename R, typename T1 >
		struct function_traits_impl< R (C::*)( T1 ) >
		{
			typedef R (*type)();
			typedef R       return_type;
			typedef C       class_type;
			static const int arg_count = 1;
		};

		template < class C, typename R, typename T1, typename T2 >
		struct function_traits_impl< R (C::*)( T1, T2 ) >
		{
			typedef R (*type)();
			typedef R       return_type;
			typedef C       class_type;
			static const int arg_count = 2;
		};

		template < class C, typename R, typename T1, typename T2, typename T3 >
		struct function_traits_impl< R (C::*)( T1, T2, T3 ) >
		{
			typedef R (*type)();
			typedef R       return_type;
			typedef C       class_type;
			static const int arg_count = 3;
		};

		template < class C, typename R, typename T1, typename T2, typename T3, typename T4 >
		struct function_traits_impl< R (C::*)( T1, T2, T3, T4 ) >
		{
			typedef R (*type)();
			typedef R       return_type;
			typedef C       class_type;
			static const int arg_count = 4;
		};

	}

	template < typename F >
	struct function_traits : public detail::function_traits_impl< typename std::add_pointer< F >::type >
	{

	};


	template < typename T >
	struct return_type
	{
		typedef typename function_traits< T >::return_type type;
	};

	template < typename T >
	struct memfn_class_type
	{
		typedef typename function_traits< T >::class_type type;
	};

	template<typename T>
	struct is_container
	{
	private:
		typedef char                      yes;
		typedef struct { char array[2]; } no;
		template<typename C> static yes test(typename C::iterator*);
		template<typename C> static no  test(...);
	public:
		static const bool value = sizeof(test<T>(0)) == sizeof(yes);
	};

	template<>
	struct is_container< std::string > {
		static const bool value = false;
	};

	template <typename TYPE> 
	void construct_object(void* object)
	{
		new (object) TYPE;
	}
	template <typename TYPE> 
	void destroy_object(void* object)
	{
		((TYPE*)object)->TYPE::~TYPE();
	}
}

#endif // NV_TYPE_TRAITS_HH
