// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file mesh_loader.hh
 * @author Kornel Kisielewicz
 * @brief mesh loader
 */

#ifndef NV_MESH_LOADER_HH
#define NV_MESH_LOADER_HH

#include <nv/common.hh>
#include <nv/string.hh>
#include <nv/interface/stream.hh>
#include <nv/gfx/mesh_data.hh>

namespace nv 
{

	class mesh_loader
	{
	public:
		mesh_loader() {}
		virtual ~mesh_loader() {}
		virtual bool load( stream& source ) = 0;
		virtual size_t get_size() = 0;
		virtual mesh_data* release_mesh_data() = 0;
	};

}

#endif // NV_MESH_LOADER_HH

