// Copyright (C) 2011 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gfx/skeletal_mesh.hh"

#include <glm/gtc/matrix_access.hpp>
#include <glm/gtx/matrix_interpolation.hpp>
#include "nv/interface/context.hh"
#include "nv/interface/device.hh"


nv::skeletal_mesh::skeletal_mesh( context* a_context, program* a_program, md5_loader* a_loader )
	: m_context( a_context )
	, m_program( a_program )
	, m_va( nullptr )
	, m_data( a_loader )
	, m_animation( nullptr )
{
	nv::uint32 vcount = a_loader->get_vertex_count(0);
	m_va = a_context->get_device()->create_vertex_array();

	m_vb_position = a_context->get_device()->create_vertex_buffer( nv::STREAM_DRAW, vcount * sizeof( nv::vec3 ), (const void*)a_loader->get_positions(0).data() );
	m_va->add_vertex_buffer( nv::slot::POSITION, m_vb_position, nv::FLOAT, 3, 0, 0, false );
	m_vb_normal = a_context->get_device()->create_vertex_buffer( nv::STREAM_DRAW, vcount * sizeof( nv::vec3 ), (const void*)a_loader->get_normals(0).data()  );
	m_va->add_vertex_buffer( nv::slot::NORMAL,   m_vb_normal, nv::FLOAT, 3, 0, 0, false );
	m_vb_tangent = a_context->get_device()->create_vertex_buffer( nv::STREAM_DRAW, vcount * sizeof( nv::vec3 ), (const void*)a_loader->get_tangents(0).data() );
	m_va->add_vertex_buffer( nv::slot::TANGENT,  m_vb_tangent, nv::FLOAT, 3, 0, 0, false );

	nv::vertex_buffer* vb = a_context->get_device()->create_vertex_buffer( nv::STATIC_DRAW, vcount * sizeof( nv::vec2 ), (const void*)a_loader->get_texcoords(0).data() );
	m_va->add_vertex_buffer( nv::slot::TEXCOORD, vb, nv::FLOAT, 2 );
	nv::index_buffer* ib = a_context->get_device()->create_index_buffer( nv::STATIC_DRAW, a_loader->get_index_count(0) * sizeof( nv::uint32 ), (const void*)a_loader->get_indices(0).data() );
	m_va->set_index_buffer( ib, nv::UINT, true );
}

void nv::skeletal_mesh::setup_animation( md5_animation* a_anim )
{
	if ( m_animation ) m_animation->reset_animation();
	m_animation = a_anim;
	m_animation->reset_animation();
}

void nv::skeletal_mesh::update( uint32 ms )
{
	if (m_animation != nullptr)
	{
		m_animation->update( ms * 0.001f );
		m_data->apply( *m_animation );
	}

	nv::uint32 usize = m_data->get_vertex_count(0) * sizeof( nv::vec3 );
	m_vb_position->bind();
	m_vb_position->update( (const void*)m_data->get_positions(0).data(), 0, usize );
	m_vb_normal  ->bind();
	m_vb_normal  ->update( (const void*)m_data->get_normals(0).data(),   0, usize );
	m_vb_tangent ->bind();
	m_vb_tangent ->update( (const void*)m_data->get_tangents(0).data(),  0, usize );

	// Technically this is not needed, because the va is just a fake class, 
	// but if it's real it will be needed?
	m_va->update_vertex_buffer( nv::slot::POSITION, m_vb_position, false );
	m_va->update_vertex_buffer( nv::slot::NORMAL,   m_vb_normal,   false );
	m_va->update_vertex_buffer( nv::slot::TANGENT,  m_vb_tangent,  false );
}

void nv::skeletal_mesh::draw( render_state& rstate )
{
	m_context->draw( nv::TRIANGLES, rstate, m_program, m_va, m_data->get_index_count(0) );
}

nv::skeletal_mesh::~skeletal_mesh()
{
	delete m_va;
}
