// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_KEYFRAMED_MESH_HH
#define NV_KEYFRAMED_MESH_HH

#include <nv/common.hh>
#include <nv/formats/md3_loader.hh>

namespace nv
{

	class keyframed_mesh
	{
	public:
		keyframed_mesh( context* a_context, keyframed_mesh_data* a_data, program* a_program );
		mat4 get_tag( const std::string& tag ) const;
		size_t get_max_frames() const;
		void set_frame( uint32 frame );
		void setup_animation( uint32 start, uint32 count, uint32 fps, bool loop );
		void update( uint32 ms );
		void draw( render_state& rstate );
		program* get_program() { return m_program; }
		~keyframed_mesh();
	private:
		context*             m_context;
		keyframed_mesh_data* m_data;
		program*             m_program;
		vertex_array*        m_va;

		int m_loc_next_position;
		int m_loc_next_normal;

		uint32 m_last_frame;
		uint32 m_next_frame;
		uint32 m_gpu_last_frame;
		uint32 m_gpu_next_frame;
		f32    m_interpolation;
		uint32 m_start_frame;
		uint32 m_stop_frame;
		uint32 m_time;
		uint32 m_fps;
		bool   m_looping;
		bool   m_active;
	};

} // namespace nv

#endif // NV_KEYFRAMED_MESH_HH
