// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file type_traits.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief type traits
 */

#ifndef NV_TYPE_TRAITS_HH
#define NV_TYPE_TRAITS_HH

#include <nv/common.hh>
#include <type_traits>

namespace nv
{

	// These could be done much better
	template <typename T>
	struct is_cstring
		: public std::integral_constant<bool,
		std::is_same<       char *, typename std::decay< T >::type >::value ||
		std::is_same< const char *, typename std::decay< T >::type >::value >
		{};

	template <typename T>
	struct is_stdstring
		: public std::integral_constant<bool,
		std::is_same< std::string, typename std::remove_cv< std::remove_reference< T > >::type >::value 
		>
	{};

	template < typename T > struct is_string : public std::integral_constant<bool, is_stdstring<T>::value || is_cstring<T>::value> {};

	// Just for once, MSVC is the good guy, and everybody else sucks.
	// Remove, once requiring standard-compliant CLANG/GCC versions.
#if NV_COMPILER == NV_MSVC
	using std::underlying_type;
#elif NV_COMPILER == NV_CLANG
	template < typename T >
	struct underlying_type
	{
		typedef __underlying_type(T) type;
	};
#else
	template< typename T >
	struct underlying_type
	{
		typedef typename std::conditional<
			T( -1 ) < T( 0 ),
			typename std::make_signed< T >::type,
			typename std::make_unsigned< T >::type
			>::type type;
	};
#endif
}

#endif // NV_TYPE_TRAITS_HH
