// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file window.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Window interface
 */

#ifndef NV_WINDOW_HH
#define NV_WINDOW_HH

#include <nv/common.hh>
#include <nv/string.hh>
#include <nv/io_event.hh>

namespace nv
{
	class context;
	class device;
	class window
	{
	public:
		virtual uint16 get_width() const = 0;
		virtual uint16 get_height() const = 0;
		virtual string get_title() const = 0;
		virtual void set_title( const string& title ) = 0;
		virtual context* get_context() = 0;
		virtual bool is_event_pending() = 0;
		virtual bool poll_event( io_event& event ) = 0;
		virtual void swap_buffers() = 0;
		virtual device* get_device() = 0;
		virtual ~window() {}
	};

} // namespace nv


#endif // NV_WINDOW_HH
