// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file md2_loader.hh
 * @author Kornel Kisielewicz
 * @brief md2 loader
 */

#ifndef NV_MD2_LOADER_HH
#define NV_MD2_LOADER_HH

#include <unordered_map>
#include <vector>
#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>
#include <nv/formats/md3_loader.hh> // TODO : remove when common interface for keyframed mesh

namespace nv 
{

	class md2_loader : public keyframed_loader
	{
	public:
		md2_loader();
		virtual ~md2_loader();
		virtual bool load( stream& source );
		virtual size_t get_size() { return m_size; }
		virtual mesh* release_mesh();
		virtual mesh* get_frame( sint32 frame );
//		virtual const md3_tag* get_tag( const std::string& name ) const;
//		virtual mat4 get_tag( sint32 frame, const std::string& name ) const;
		sint32 get_max_frames() const;
//		void load_tag_names( std::vector< std::string >& tags );
//		void load_tags( std::vector<mat4>& t, const std::string& tag );
		void load_positions( std::vector<vec3>& p, sint32 frame =-1 );
		void load_normals( std::vector<vec3>& n, sint32 frame =-1 );
		void load_texcoords( std::vector<vec2>& t );
		void load_indicies( std::vector<uint16>& idx );
	private:
		void reindex();
	private:
		void* m_md2;
//		std::unordered_map< std::string, md3_tag > m_tags;
		std::size_t m_size;
		std::vector< uint16 > m_new_indexes;
		std::vector< uint16 > m_new_vindexes;
		std::vector< uint16 > m_new_tindexes;
	};

}

#endif // NV_MD2_LOADER_HH
