// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

/**
 * @file md5_loader.hh
 * @author Kornel Kisielewicz
 * @brief md5 loader
 */

#ifndef NV_MD5_LOADER_HH
#define NV_MD5_LOADER_HH

#include <unordered_map>
#include <vector>
#include <nv/common.hh>
#include <nv/interface/mesh_loader.hh>

namespace nv 
{

	class md5_loader : public mesh_loader
	{
	public:
		md5_loader() {};
		virtual ~md5_loader() {};
		virtual bool load( stream& source );
		virtual size_t get_size() { return m_size; }
		virtual mesh* release_mesh();
		virtual mesh* get_frame( sint32 frame ) { return nullptr; }
//		virtual const md3_tag* get_tag( const std::string& name ) const;
//		virtual mat4 get_tag( sint32 frame, const std::string& name ) const;
//		sint32 get_max_frames() const;
//		void load_tag_names( std::vector< std::string >& tags );
//		void load_tags( std::vector<mat4>& t, const std::string& tag );
//		void load_positions( std::vector<vec3>& p, sint32 frame =-1 );
//		void load_normals( std::vector<vec3>& n, sint32 frame =-1 );
//		void load_texcoords( std::vector<vec2>& t );
//		void load_indicies( std::vector<uint16>& idx );

	protected:
		typedef std::vector<glm::vec3> md5_vec_buffer;
		typedef std::vector<glm::vec2> md5_tc_buffer;
		typedef std::vector<uint32> md5_index_buffer;

		struct md5_vertex
		{
			glm::vec3 position;
			glm::vec3 normal;
			glm::vec3 tangent;
			glm::vec2 texcoord;
			int       start_weight;
			int       weight_count;
		};

		typedef std::vector<md5_vertex> md5_vertex_list;

		struct md5_triangle
		{
			int indices[3];
		};
		typedef std::vector<md5_triangle> md5_triangle_list;

		struct md5_weight
		{
			int       joint_id;
			float     bias;
			glm::vec3 pos;
		};
		typedef std::vector<md5_weight> md5_weight_list;

		struct md5_joint
		{
			std::string name;
			int   parent_id;
			vec3  pos;
			quat  orient;
		};
		typedef std::vector<md5_joint> md5_joint_list;

		struct md5_mesh
		{
			std::string       shader;
			md5_vertex_list   verts;
			md5_triangle_list tris;
			md5_weight_list   weights;

			md5_vec_buffer    position_buffer; 
			md5_vec_buffer    normal_buffer;
			md5_vec_buffer    tangent_buffer;
			md5_tc_buffer     texcoord_buffer;
			md5_index_buffer  index_buffer;
		};
		typedef std::vector<md5_mesh> md5_mesh_list;
	protected:
		bool prepare_mesh( md5_mesh& mesh );
		bool prepare_normals( md5_mesh& mesh );

	protected:
		uint32 m_md5_version;
		uint32 m_num_joints;
		uint32 m_num_meshes;

		md5_joint_list m_joints;
		md5_mesh_list  m_meshes;

		//bool           m_animation_present;
		//md5_animation m_animation;

		size_t m_size;
		glm::mat4x4     m_model_matrix;
	};

}

#endif // NV_MD5_LOADER_HH
