// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lua/lua_values.hh"

#include "nv/lua/lua_raw.hh"
#include "nv/object.hh"

void nv::lua::detail::push_value( lua_State *L, long n )
{
	lua_pushinteger( L, n );
}

void nv::lua::detail::push_value( lua_State *L, double d )
{
	lua_pushnumber( L, d );
}

void nv::lua::detail::push_value( lua_State *L, bool n )
{
	lua_pushboolean( L, n );
}

void nv::lua::detail::push_value( lua_State *L, const char* s )
{
	lua_pushstring( L, s );
}

void nv::lua::detail::push_value( lua_State *L, const std::string& s )
{
	lua_pushstring( L, s.c_str() );
}

void nv::lua::detail::push_value( lua_State *L, object* o )
{
	if ( o == nullptr )
	{
		lua_pushnil( L );
	}
	else
	{
		lua_rawgeti( L, LUA_REGISTRYINDEX, o->get_lua_index() );
	}
}

void nv::lua::detail::push_value( lua_State *L, void* p )
{
	lua_pushlightuserdata( L, p );
}

void nv::lua::detail::pop_value( lua_State *L, long& n )
{
	n = lua_tointeger( L, -1 );
	lua_pop( L, 1 );
}

void nv::lua::detail::pop_value( lua_State *L, double& d )
{
	d = lua_tonumber( L, -1 );
	lua_pop( L, 1 );
}

void nv::lua::detail::pop_value( lua_State *L, bool& n )
{
	n = lua_toboolean( L, -1 ) != 0;
	lua_pop( L, 1 );
}

void nv::lua::detail::pop_value( lua_State *L, std::string& s )
{
	s = lua_tostring( L, -1 ); 
	lua_pop( L, 1 );
}

void nv::lua::detail::pop_value( lua_State *L, object*& o )
{
	o = nullptr;
	if ( lua_istable( L , -1 ) )
	{
		lua_pushstring( L, "__ptr" );
		lua_rawget( L, -1 );
		if ( lua_isuserdata( L, -1 ) )
		{
			o = (object*)( lua_touserdata( L, -1 ) );
		} 
		lua_pop( L, 1 );
	}
	lua_pop( L, 1 );
}

void nv::lua::detail::pop_value( lua_State *L, void*& p )
{
	p = lua_touserdata( L, -1 );
	lua_pop( L, 1 );
}

