// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file stream.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief stream interface
 */

#ifndef NV_STREAM_HH
#define NV_STREAM_HH

#include <nv/common.hh>

namespace nv
{

	enum class origin : uint32 
	{
		SET = 0,
		CUR = 1,
		END = 2,
	};

	class stream
	{
	protected:
		stream() {}
	public:
		virtual ~stream() {}
		virtual size_t read( void* buffer, size_t size, size_t count ) = 0;
		virtual size_t write( void* buffer, size_t size, size_t count ) = 0;
		virtual bool seek( size_t offset, origin orig ) = 0;
		virtual size_t tell() = 0;
		virtual size_t size() = 0;
		virtual void flush() = 0;
	};

} // namespace nv

#endif // NV_STREAM_HH
