/* SDL_video.h defines */
NV_SDL_FUN( int, SDL_VideoInit, (const char *driver_name, Uint32 flags) );
NV_SDL_FUN( void, SDL_VideoQuit, (void) );
NV_SDL_FUN( char *, SDL_VideoDriverName, (char *namebuf, int maxlen) );
NV_SDL_FUN( SDL_Surface *, SDL_GetVideoSurface, (void) );
NV_SDL_FUN( const SDL_VideoInfo *, SDL_GetVideoInfo, (void) );
NV_SDL_FUN( int, SDL_VideoModeOK, (int width, int height, int bpp, Uint32 flags) );
NV_SDL_FUN( SDL_Rect **, SDL_ListModes, (SDL_PixelFormat *format, Uint32 flags) );
NV_SDL_FUN( SDL_Surface *, SDL_SetVideoMode, (int width, int height, int bpp, Uint32 flags) );
NV_SDL_FUN( void, SDL_UpdateRects, (SDL_Surface *screen, int numrects, SDL_Rect *rects) );
NV_SDL_FUN( void, SDL_UpdateRect, (SDL_Surface *screen, Sint32 x, Sint32 y, Uint32 w, Uint32 h) );
NV_SDL_FUN( int, SDL_Flip, (SDL_Surface *screen) );
NV_SDL_FUN( int, SDL_SetGamma, (float red, float green, float blue) );
NV_SDL_FUN( int, SDL_SetGammaRamp, (const Uint16 *red, const Uint16 *green, const Uint16 *blue) );
NV_SDL_FUN( int, SDL_GetGammaRamp, (Uint16 *red, Uint16 *green, Uint16 *blue) );
NV_SDL_FUN( int, SDL_SetColors, (SDL_Surface *surface, SDL_Color *colors, int firstcolor, int ncolors) );
NV_SDL_FUN( int, SDL_SetPalette, (SDL_Surface *surface, int flags, SDL_Color *colors, int firstcolor, int ncolors) );
NV_SDL_FUN( Uint32, SDL_MapRGB, (const SDL_PixelFormat * const format, const Uint8 r, const Uint8 g, const Uint8 b) );
NV_SDL_FUN( Uint32, SDL_MapRGBA, (const SDL_PixelFormat * const format, const Uint8 r, const Uint8 g, const Uint8 b, const Uint8 a) );
NV_SDL_FUN( void, SDL_GetRGB, (Uint32 pixel, const SDL_PixelFormat * const fmt, Uint8 *r, Uint8 *g, Uint8 *b) );
NV_SDL_FUN( void, SDL_GetRGBA, (Uint32 pixel,	const SDL_PixelFormat * const fmt, Uint8 *r, Uint8 *g, Uint8 *b, Uint8 *a) );
NV_SDL_FUN( int, SDL_SetColorKey, (SDL_Surface *surface, Uint32 flag, Uint32 key) );
NV_SDL_FUN( int, SDL_SetAlpha, (SDL_Surface *surface, Uint32 flag, Uint8 alpha) );
NV_SDL_FUN( int, SDL_UpperBlit, (SDL_Surface *src, SDL_Rect *srcrect, SDL_Surface *dst, SDL_Rect *dstrect) );
NV_SDL_FUN( int, SDL_LowerBlit, (SDL_Surface *src, SDL_Rect *srcrect, SDL_Surface *dst, SDL_Rect *dstrect) );
NV_SDL_FUN( int, SDL_FillRect, (SDL_Surface *dst, SDL_Rect *dstrect, Uint32 color) );
NV_SDL_FUN( SDL_Surface *, SDL_DisplayFormat, (SDL_Surface *surface) );
NV_SDL_FUN( SDL_Surface *, SDL_DisplayFormatAlpha, (SDL_Surface *surface) );
NV_SDL_FUN( int, SDL_WM_IconifyWindow, (void) );
NV_SDL_FUN( int, SDL_WM_ToggleFullScreen, (SDL_Surface *surface) );
NV_SDL_FUN( SDL_GrabMode, SDL_WM_GrabInput, (SDL_GrabMode mode) ); 
NV_SDL_FUN( void, SDL_GL_SwapBuffers, (void) );
NV_SDL_FUN( void, SDL_GL_UpdateRects, (int numrects, SDL_Rect* rects) );
NV_SDL_FUN( void, SDL_GL_Lock, (void) );
NV_SDL_FUN( void, SDL_GL_Unlock, (void) );
NV_SDL_FUN( void, SDL_WM_SetCaption, (const char *title, const char *icon) );
NV_SDL_FUN( void, SDL_WM_GetCaption, (char **title, char **icon) );
NV_SDL_FUN( void, SDL_WM_SetIcon, (SDL_Surface *icon, Uint8 *mask) );

/* SDL_audio.h functions */
NV_SDL_FUN( char *, SDL_AudioDriverName, (char *namebuf, int maxlen) );

/* SDL_cpuinfo.h functions */
NV_SDL_FUN( SDL_bool, SDL_HasMMXExt, (void) );
NV_SDL_FUN( SDL_bool, SDL_Has3DNowExt, (void) );

/* SDL_error.h functions */
NV_SDL_FUN( void, SDL_SetError, (const char *fmt, ...) );
NV_SDL_FUN( void, SDL_Error, (SDL_errorcode code) );

/* SDL_active.h functions */
NV_SDL_FUN( Uint8, SDL_GetAppState, (void) );

/* SDL_keyboard.h functions */
NV_SDL_FUN( int, SDL_EnableUNICODE, (int enable) );
NV_SDL_FUN( int, SDL_EnableKeyRepeat, (int delay, int interval) );
NV_SDL_FUN( void, SDL_GetKeyRepeat, (int *delay, int *interval) );
NV_SDL_FUN( Uint8 *, SDL_GetKeyState, (int *numkeys) );
NV_SDL_FUN( SDLMod, SDL_GetModState, (void) );
NV_SDL_FUN( void, SDL_SetModState, (SDLMod modstate) );
NV_SDL_FUN( char *, SDL_GetKeyName, (SDLKey key) );
 
/* SDL_mouse.h functions */
NV_SDL_FUN( Uint8, SDL_GetMouseState, (int *x, int *y) );
NV_SDL_FUN( Uint8, SDL_GetRelativeMouseState, (int *x, int *y) );
NV_SDL_FUN( void, SDL_WarpMouse, (Uint16 x, Uint16 y) );
NV_SDL_FUN( SDL_Cursor *, SDL_CreateCursor, (Uint8 *data, Uint8 *mask, int w, int h, int hot_x, int hot_y) );

/* SDL_joystick.h functions */
NV_SDL_FUN( const char *, SDL_JoystickName, (int device_index) );
NV_SDL_FUN( int, SDL_JoystickOpened, (int device_index) );
NV_SDL_FUN( int, SDL_JoystickIndex, (SDL_Joystick *joystick) );

/* SDL_version.h functions */
NV_SDL_FUN( const SDL_version *, SDL_Linked_Version, (void) ); 

/* SDL_event.h functions */
NV_SDL_FUN( int, SDL_PeepEvents, (SDL_Event *events, int numevents, SDL_eventaction action, Uint32 mask) );
NV_SDL_FUN( void, SDL_SetEventFilter, (SDL_EventFilter filter) );
NV_SDL_FUN( SDL_EventFilter, SDL_GetEventFilter, (void) );
NV_SDL_FUN( Uint8, SDL_EventState, (Uint8 etype, int state) );
