// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/lua.hh"

#if defined( NV_LUA_DYNAMIC )

#include "nv/library.hh"

#if NV_LUA_VERSION == NV_LUA_52
#	undef luaL_loadfile
#	undef luaL_loadbuffer
#	undef luaL_prepbuffer
#	undef lua_tonumber
#	undef lua_tointeger
#	undef lua_tounsigned
#	undef lua_call
#	undef lua_pcall
#	undef lua_yield
#endif

#define NV_LUA_FUN( rtype, fname, fparams ) rtype (*fname) fparams = nullptr;
#if NV_LUA_VERSION == NV_LUA_52
#	define NV_LUA_FUN_51( rtype, fname, fparams )
#	define NV_LUA_FUN_52 NV_LUA_FUN
#elif NV_LUA_VERSION == NV_LUA_51
#	define NV_LUA_FUN_51 NV_LUA_FUN
#	define NV_LUA_FUN_52( rtype, fname, fparams ) 
#else
#	define NV_LUA_FUN_51( rtype, fname, fparams )
#	define NV_LUA_FUN_52( rtype, fname, fparams ) 
#endif

#include <nv/lib/detail/lua_functions.inc>

#undef NV_LUA_FUN
#undef NV_LUA_FUN_51
#undef NV_LUA_FUN_52

bool nv::load_lua_library( const char* path )
{
	static nv::library lua_library;
	if ( lua_library.is_open() ) return true;
	lua_library.open( path );

#	define NV_LUA_FUN( rtype, fname, fparams ) *(void **) (&fname) = lua_library.get(#fname);
#	if NV_LUA_VERSION == NV_LUA_52
#		define NV_LUA_FUN_51( rtype, fname, fparams )
#		define NV_LUA_FUN_52 NV_LUA_FUN
#	elif NV_LUA_VERSION == NV_LUA_51
#		define NV_LUA_FUN_51 NV_LUA_FUN
#		define NV_LUA_FUN_52( rtype, fname, fparams ) 
#	else
#		define NV_LUA_FUN_51( rtype, fname, fparams )
#		define NV_LUA_FUN_52( rtype, fname, fparams ) 
#	endif

#	include <nv/lib/detail/lua_functions.inc>

#	undef NV_LUA_FUN
#	undef NV_LUA_FUN_51
#	undef NV_LUA_FUN_52
	return true;
}

#endif
