#version 120
attribute vec3 coords;
attribute vec3 material;
varying vec3 f_coord;
varying vec3 f_normal;
varying vec3 f_material;
varying float f_diffuse_value;
uniform mat4 matrix_mvp;
uniform vec3 light;

void main(void) {
	f_normal = vec3(0,0,0);
	f_normal[int(abs(material.y)-1)] = sign( material.y );
	vec3 vnormal  = normalize(f_normal);
	vec3 vlight   = normalize(light - coords);
	float diffuse = max(dot(vlight, vnormal), 0.0);
	f_diffuse_value = diffuse;
	f_coord = coords;
	f_material = material;
	gl_Position = matrix_mvp * vec4(coords, 1.0);
}
