// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/common.hh"
#include "nv/lib/gl.hh"

#if defined( NV_GL_DYNAMIC )

#include "nv/library.hh"

#if defined( NV_SDL_GL )
#	include "nv/lib/sdl12.hh"
#endif

/* OpenGL 1.1 non-deprecated functions */
void (NV_GL_APIENTRY *glCullFace) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glFrontFace) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glHint) ( GLenum, GLenum ) = nullptr;
void (NV_GL_APIENTRY *glLineWidth) ( GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glPointSize) ( GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glPolygonMode) ( GLenum, GLenum ) = nullptr;
void (NV_GL_APIENTRY *glScissor) ( GLint , GLint , GLsizei , GLsizei ) = nullptr;
void (NV_GL_APIENTRY *glTexParameterf) ( GLenum , GLenum , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glTexParameterfv) ( GLenum , GLenum , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glTexParameteri) ( GLenum , GLenum , GLint ) = nullptr;
void (NV_GL_APIENTRY *glTexParameteriv) ( GLenum , GLenum , const GLint *) = nullptr;
void (NV_GL_APIENTRY *glTexImage1D) ( GLenum , GLint , GLint , GLsizei , GLint , GLenum , GLenum , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glTexImage2D) ( GLenum , GLint , GLint , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glDrawBuffer) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glClear) ( GLbitfield ) = nullptr;
void (NV_GL_APIENTRY *glClearColor) ( GLfloat , GLfloat , GLfloat , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glClearStencil) ( GLint ) = nullptr;
void (NV_GL_APIENTRY *glClearDepth) ( GLdouble ) = nullptr;
void (NV_GL_APIENTRY *glStencilMask) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glColorMask) ( GLboolean , GLboolean , GLboolean , GLboolean ) = nullptr;
void (NV_GL_APIENTRY *glDepthMask) ( GLboolean ) = nullptr;
void (NV_GL_APIENTRY *glDisable) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glEnable) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glFinish) ( void ) = nullptr;
void (NV_GL_APIENTRY *glFlush) ( void ) = nullptr;
void (NV_GL_APIENTRY *glBlendFunc) ( GLenum, GLenum ) = nullptr;
void (NV_GL_APIENTRY *glLogicOp) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glStencilFunc) ( GLenum , GLint , GLuint ) = nullptr;
void (NV_GL_APIENTRY *glStencilOp) ( GLenum , GLenum , GLenum ) = nullptr;
void (NV_GL_APIENTRY *glDepthFunc) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glPixelStoref) ( GLenum , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glPixelStorei) ( GLenum , GLint ) = nullptr;
void (NV_GL_APIENTRY *glReadBuffer) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glReadPixels) ( GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glGetBooleanv) ( GLenum , GLboolean *) = nullptr;
void (NV_GL_APIENTRY *glGetDoublev) ( GLenum , GLdouble *) = nullptr;
GLenum (NV_GL_APIENTRY *glGetError) ( void ) = nullptr;
void (NV_GL_APIENTRY *glGetFloatv) ( GLenum , GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glGetIntegerv) ( GLenum , GLint *) = nullptr;
const GLubyte * (NV_GL_APIENTRY *glGetString) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glGetTexImage) ( GLenum , GLint , GLenum , GLenum , GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glGetTexParameterfv) ( GLenum , GLenum , GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glGetTexParameteriv) ( GLenum , GLenum , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetTexLevelParameterfv) ( GLenum , GLint , GLenum , GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glGetTexLevelParameteriv) ( GLenum , GLint , GLenum , GLint *) = nullptr;
GLboolean (NV_GL_APIENTRY *glIsEnabled) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glDepthRange) ( GLdouble , GLdouble ) = nullptr;
void (NV_GL_APIENTRY *glViewport) ( GLint , GLint , GLsizei , GLsizei ) = nullptr;
void (NV_GL_APIENTRY *glDrawArrays) ( GLenum , GLint , GLsizei ) = nullptr;
void (NV_GL_APIENTRY *glDrawElements) ( GLenum , GLsizei , GLenum , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glGetPointerv) ( GLenum , GLvoid* *) = nullptr;
void (NV_GL_APIENTRY *glPolygonOffset) ( GLfloat , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glCopyTexImage1D) ( GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLint ) = nullptr;
void (NV_GL_APIENTRY *glCopyTexImage2D) ( GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLsizei , GLint ) = nullptr;
void (NV_GL_APIENTRY *glCopyTexSubImage1D) ( GLenum , GLint , GLint , GLint , GLint , GLsizei ) = nullptr;
void (NV_GL_APIENTRY *glCopyTexSubImage2D) ( GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei ) = nullptr;
void (NV_GL_APIENTRY *glTexSubImage1D) ( GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glTexSubImage2D) ( GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glBindTexture) ( GLenum , GLuint ) = nullptr;
void (NV_GL_APIENTRY *glDeleteTextures) ( GLsizei , const GLuint *) = nullptr;
void (NV_GL_APIENTRY *glGenTextures) ( GLsizei , GLuint *) = nullptr;
GLboolean (NV_GL_APIENTRY *glIsTexture) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glIndexub) ( GLubyte ) = nullptr;
void (NV_GL_APIENTRY *glIndexubv) ( const GLubyte *) = nullptr;

/* OpenGL 1.2 non-deprecated functions */
void (NV_GL_APIENTRY *glBlendColor) ( GLfloat , GLfloat , GLfloat , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glBlendEquation) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glDrawRangeElements) ( GLenum , GLuint , GLuint , GLsizei , GLenum , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glTexSubImage3D) ( GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glCopyTexSubImage3D) ( GLenum , GLint , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei ) = nullptr;

/* OpenGL 1.3 non-deprecated functions */
void (NV_GL_APIENTRY *glActiveTexture) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glSampleCoverage) ( GLfloat , GLboolean ) = nullptr;
void (NV_GL_APIENTRY *glCompressedTexImage3D) ( GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glCompressedTexImage2D) ( GLenum , GLint , GLenum , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glCompressedTexImage1D) ( GLenum , GLint , GLenum , GLsizei , GLint , GLsizei , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glCompressedTexSubImage3D) ( GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glCompressedTexSubImage2D) ( GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glCompressedTexSubImage1D) ( GLenum , GLint , GLint , GLsizei , GLenum , GLsizei , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glGetCompressedTexImage) ( GLenum , GLint , GLvoid *) = nullptr;

/* OpenGL 1.4 non-deprecated functions */
void (NV_GL_APIENTRY *glBlendFuncSeparate) ( GLenum , GLenum , GLenum , GLenum ) = nullptr;
void (NV_GL_APIENTRY *glMultiDrawArrays) ( GLenum , const GLint *, const GLsizei *, GLsizei ) = nullptr;
void (NV_GL_APIENTRY *glMultiDrawElements) ( GLenum , const GLsizei *, GLenum , const GLvoid* const *, GLsizei ) = nullptr;
void (NV_GL_APIENTRY *glPointParameterf) ( GLenum , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glPointParameterfv) ( GLenum , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glPointParameteri) ( GLenum , GLint ) = nullptr;
void (NV_GL_APIENTRY *glPointParameteriv) ( GLenum , const GLint *) = nullptr;

/* OpenGL 1.5 non-deprecated functions */
void (NV_GL_APIENTRY *glGenQueries) ( GLsizei , GLuint *) = nullptr;
void (NV_GL_APIENTRY *glDeleteQueries) ( GLsizei , const GLuint *) = nullptr;
GLboolean (NV_GL_APIENTRY *glIsQuery) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glBeginQuery) ( GLenum , GLuint ) = nullptr;
void (NV_GL_APIENTRY *glEndQuery) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glGetQueryiv) ( GLenum , GLenum , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetQueryObjectiv) ( GLuint , GLenum , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetQueryObjectuiv) ( GLuint , GLenum , GLuint *) = nullptr;
void (NV_GL_APIENTRY *glBindBuffer) ( GLenum , GLuint ) = nullptr;
void (NV_GL_APIENTRY *glDeleteBuffers) ( GLsizei , const GLuint *) = nullptr;
void (NV_GL_APIENTRY *glGenBuffers) ( GLsizei , GLuint *) = nullptr;
GLboolean (NV_GL_APIENTRY *glIsBuffer) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glBufferData) ( GLenum , GLsizeiptr , const GLvoid *, GLenum ) = nullptr;
void (NV_GL_APIENTRY *glBufferSubData) ( GLenum , GLintptr , GLsizeiptr , const GLvoid *) = nullptr;
void (NV_GL_APIENTRY *glGetBufferSubData) ( GLenum , GLintptr , GLsizeiptr , GLvoid *) = nullptr;
GLvoid* (NV_GL_APIENTRY *glMapBuffer) ( GLenum , GLenum ) = nullptr;
GLboolean (NV_GL_APIENTRY *glUnmapBuffer) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glGetBufferParameteriv) ( GLenum , GLenum , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetBufferPointerv) ( GLenum , GLenum , GLvoid* *) = nullptr;

/* OpenGL 2.0 non-deprecated functions */
void (NV_GL_APIENTRY *glBlendEquationSeparate) ( GLenum , GLenum ) = nullptr;
void (NV_GL_APIENTRY *glDrawBuffers) ( GLsizei , const GLenum *) = nullptr;
void (NV_GL_APIENTRY *glStencilOpSeparate) ( GLenum , GLenum , GLenum , GLenum ) = nullptr;
void (NV_GL_APIENTRY *glStencilFuncSeparate) ( GLenum , GLenum , GLint , GLuint ) = nullptr;
void (NV_GL_APIENTRY *glStencilMaskSeparate) ( GLenum , GLuint ) = nullptr;
void (NV_GL_APIENTRY *glAttachShader) ( GLuint , GLuint ) = nullptr;
void (NV_GL_APIENTRY *glBindAttribLocation) ( GLuint , GLuint , const GLchar *) = nullptr;
void (NV_GL_APIENTRY *glCompileShader) ( GLuint ) = nullptr;
GLuint (NV_GL_APIENTRY *glCreateProgram) ( void ) = nullptr;
GLuint (NV_GL_APIENTRY *glCreateShader) ( GLenum ) = nullptr;
void (NV_GL_APIENTRY *glDeleteProgram) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glDeleteShader) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glDetachShader) ( GLuint, GLuint ) = nullptr;
void (NV_GL_APIENTRY *glDisableVertexAttribArray) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glEnableVertexAttribArray) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glGetActiveAttrib) ( GLuint , GLuint , GLsizei , GLsizei *, GLint *, GLenum *, GLchar *) = nullptr;
void (NV_GL_APIENTRY *glGetActiveUniform) ( GLuint , GLuint , GLsizei , GLsizei *, GLint *, GLenum *, GLchar *) = nullptr;
void (NV_GL_APIENTRY *glGetAttachedShaders) ( GLuint , GLsizei , GLsizei *, GLuint *) = nullptr;
GLint (NV_GL_APIENTRY *glGetAttribLocation) ( GLuint , const GLchar *) = nullptr;
void (NV_GL_APIENTRY *glGetProgramiv) ( GLuint , GLenum , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetProgramInfoLog) ( GLuint , GLsizei , GLsizei *, GLchar *) = nullptr;
void (NV_GL_APIENTRY *glGetShaderiv) ( GLuint , GLenum , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetShaderInfoLog) ( GLuint , GLsizei , GLsizei *, GLchar *) = nullptr;
void (NV_GL_APIENTRY *glGetShaderSource) ( GLuint , GLsizei , GLsizei *, GLchar *) = nullptr;
GLint (NV_GL_APIENTRY *glGetUniformLocation) ( GLuint , const GLchar *) = nullptr;
void (NV_GL_APIENTRY *glGetUniformfv) ( GLuint , GLint , GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glGetUniformiv) ( GLuint , GLint , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetVertexAttribdv) ( GLuint , GLenum , GLdouble *) = nullptr;
void (NV_GL_APIENTRY *glGetVertexAttribfv) ( GLuint , GLenum , GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glGetVertexAttribiv) ( GLuint , GLenum , GLint *) = nullptr;
void (NV_GL_APIENTRY *glGetVertexAttribPointerv) ( GLuint , GLenum , GLvoid* *) = nullptr;
GLboolean (NV_GL_APIENTRY *glIsProgram) ( GLuint ) = nullptr;
GLboolean (NV_GL_APIENTRY *glIsShader) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glLinkProgram) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glShaderSource) ( GLuint , GLsizei , const GLchar* const *, const GLint *) = nullptr;
void (NV_GL_APIENTRY *glUseProgram) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glUniform1f) ( GLint , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glUniform2f) ( GLint , GLfloat , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glUniform3f) ( GLint , GLfloat , GLfloat , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glUniform4f) ( GLint , GLfloat , GLfloat , GLfloat , GLfloat ) = nullptr;
void (NV_GL_APIENTRY *glUniform1i) ( GLint , GLint ) = nullptr;
void (NV_GL_APIENTRY *glUniform2i) ( GLint , GLint , GLint ) = nullptr;
void (NV_GL_APIENTRY *glUniform3i) ( GLint , GLint , GLint , GLint ) = nullptr;
void (NV_GL_APIENTRY *glUniform4i) ( GLint , GLint , GLint , GLint , GLint ) = nullptr;
void (NV_GL_APIENTRY *glUniform1fv) ( GLint , GLsizei , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniform2fv) ( GLint , GLsizei , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniform3fv) ( GLint , GLsizei , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniform4fv) ( GLint , GLsizei , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniform1iv) ( GLint , GLsizei , const GLint *) = nullptr;
void (NV_GL_APIENTRY *glUniform2iv) ( GLint , GLsizei , const GLint *) = nullptr;
void (NV_GL_APIENTRY *glUniform3iv) ( GLint , GLsizei , const GLint *) = nullptr;
void (NV_GL_APIENTRY *glUniform4iv) ( GLint , GLsizei , const GLint *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix2fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix3fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix4fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glValidateProgram) ( GLuint ) = nullptr;
void (NV_GL_APIENTRY *glVertexAttribPointer) ( GLuint , GLint , GLenum , GLboolean , GLsizei , const GLvoid *) = nullptr;

/* OpenGL 2.1 non-deprecated functions */
void (NV_GL_APIENTRY *glUniformMatrix2x3fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix3x2fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix2x4fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix4x2fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix3x4fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;
void (NV_GL_APIENTRY *glUniformMatrix4x3fv) ( GLint , GLsizei , GLboolean , const GLfloat *) = nullptr;

bool nv::load_gl_library( const char* path )
{
#if defined( NV_SDL_GL )
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = SDL_GL_GetProcAddress(#symbol);
#else
	static nv::library gl_library;
	if ( gl_library.is_open() ) return true;
	gl_library.open( path );

	void * (NV_GL_APIENTRY *ext_loader) (const char* proc) = nullptr;
#	if NV_PLATFORM == NV_WINDOWS 
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
		*(void **) (&ext_loader) = gl_library.get("wglGetProcAddress");
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = ext_loader(#symbol);
#	elif NV_PLATFORM == NV_LINUX
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
		*(void **) (&ext_loader) = gl_library.get("glXGetProcAddress");
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = ext_loader(#symbol);
#	else
#		define NV_GL_LOAD( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
#		define NV_GL_LOAD_EXT( symbol ) *(void **) (&symbol) = gl_library.get(#symbol);
#	endif
#endif

/* OpenGL 1.1 non-deprecated functions */
	NV_GL_LOAD( glCullFace );
	NV_GL_LOAD( glFrontFace );
	NV_GL_LOAD( glHint );
	NV_GL_LOAD( glLineWidth );
	NV_GL_LOAD( glPointSize );
	NV_GL_LOAD( glPolygonMode );
	NV_GL_LOAD( glScissor );
	NV_GL_LOAD( glTexParameterf );
	NV_GL_LOAD( glTexParameterfv );
	NV_GL_LOAD( glTexParameteri );
	NV_GL_LOAD( glTexParameteriv );
	NV_GL_LOAD( glTexImage1D );
	NV_GL_LOAD( glTexImage2D );
	NV_GL_LOAD( glDrawBuffer );
	NV_GL_LOAD( glClear );
	NV_GL_LOAD( glClearColor );
	NV_GL_LOAD( glClearStencil );
	NV_GL_LOAD( glClearDepth );
	NV_GL_LOAD( glStencilMask );
	NV_GL_LOAD( glColorMask );
	NV_GL_LOAD( glDepthMask );
	NV_GL_LOAD( glDisable );
	NV_GL_LOAD( glEnable );
	NV_GL_LOAD( glFinish );
	NV_GL_LOAD( glFlush );
	NV_GL_LOAD( glBlendFunc );
	NV_GL_LOAD( glLogicOp );
	NV_GL_LOAD( glStencilFunc );
	NV_GL_LOAD( glStencilOp );
	NV_GL_LOAD( glDepthFunc );
	NV_GL_LOAD( glPixelStoref );
	NV_GL_LOAD( glPixelStorei );
	NV_GL_LOAD( glReadBuffer );
	NV_GL_LOAD( glReadPixels );
	NV_GL_LOAD( glGetBooleanv );
	NV_GL_LOAD( glGetDoublev );
	NV_GL_LOAD( glGetError );
	NV_GL_LOAD( glGetFloatv );
	NV_GL_LOAD( glGetIntegerv );
	NV_GL_LOAD( glGetString );
	NV_GL_LOAD( glGetTexImage );
	NV_GL_LOAD( glGetTexParameterfv );
	NV_GL_LOAD( glGetTexParameteriv );
	NV_GL_LOAD( glGetTexLevelParameterfv );
	NV_GL_LOAD( glGetTexLevelParameteriv );
	NV_GL_LOAD( glIsEnabled );
	NV_GL_LOAD( glDepthRange );
	NV_GL_LOAD( glViewport );
	NV_GL_LOAD( glDrawArrays );
	NV_GL_LOAD( glDrawElements );
	NV_GL_LOAD( glGetPointerv );
	NV_GL_LOAD( glPolygonOffset );
	NV_GL_LOAD( glCopyTexImage1D );
	NV_GL_LOAD( glCopyTexImage2D );
	NV_GL_LOAD( glCopyTexSubImage1D );
	NV_GL_LOAD( glCopyTexSubImage2D );
	NV_GL_LOAD( glTexSubImage1D );
	NV_GL_LOAD( glTexSubImage2D );
	NV_GL_LOAD( glBindTexture );
	NV_GL_LOAD( glDeleteTextures );
	NV_GL_LOAD( glGenTextures );
	NV_GL_LOAD( glIsTexture );
	NV_GL_LOAD( glIndexub );
	NV_GL_LOAD( glIndexubv );

/* OpenGL 1.2 non-deprecated functions */
	NV_GL_LOAD_EXT( glBlendColor );
	NV_GL_LOAD_EXT( glBlendEquation );
	NV_GL_LOAD_EXT( glDrawRangeElements );
	NV_GL_LOAD_EXT( glTexSubImage3D );
	NV_GL_LOAD_EXT( glCopyTexSubImage3D );

/* OpenGL 1.3 non-deprecated functions */
	NV_GL_LOAD_EXT( glActiveTexture );
	NV_GL_LOAD_EXT( glSampleCoverage );
	NV_GL_LOAD_EXT( glCompressedTexImage3D );
	NV_GL_LOAD_EXT( glCompressedTexImage2D );
	NV_GL_LOAD_EXT( glCompressedTexImage1D );
	NV_GL_LOAD_EXT( glCompressedTexSubImage3D );
	NV_GL_LOAD_EXT( glCompressedTexSubImage2D );
	NV_GL_LOAD_EXT( glCompressedTexSubImage1D );
	NV_GL_LOAD_EXT( glGetCompressedTexImage );

/* OpenGL 1.4 non-deprecated functions */
	NV_GL_LOAD_EXT( glBlendFuncSeparate );
	NV_GL_LOAD_EXT( glMultiDrawArrays );
	NV_GL_LOAD_EXT( glMultiDrawElements );
	NV_GL_LOAD_EXT( glPointParameterf );
	NV_GL_LOAD_EXT( glPointParameterfv );
	NV_GL_LOAD_EXT( glPointParameteri );
	NV_GL_LOAD_EXT( glPointParameteriv );

/* OpenGL 1.5 non-deprecated functions */
	NV_GL_LOAD_EXT( glGenQueries );
	NV_GL_LOAD_EXT( glDeleteQueries );
	NV_GL_LOAD_EXT( glIsQuery );
	NV_GL_LOAD_EXT( glBeginQuery );
	NV_GL_LOAD_EXT( glEndQuery );
	NV_GL_LOAD_EXT( glGetQueryiv );
	NV_GL_LOAD_EXT( glGetQueryObjectiv );
	NV_GL_LOAD_EXT( glGetQueryObjectuiv );
	NV_GL_LOAD_EXT( glBindBuffer );
	NV_GL_LOAD_EXT( glDeleteBuffers );
	NV_GL_LOAD_EXT( glGenBuffers );
	NV_GL_LOAD_EXT( glIsBuffer );
	NV_GL_LOAD_EXT( glBufferData );
	NV_GL_LOAD_EXT( glBufferSubData );
	NV_GL_LOAD_EXT( glGetBufferSubData );
	NV_GL_LOAD_EXT( glMapBuffer );
	NV_GL_LOAD_EXT( glUnmapBuffer );
	NV_GL_LOAD_EXT( glGetBufferParameteriv );
	NV_GL_LOAD_EXT( glGetBufferPointerv );

/* OpenGL 2.0 non-deprecated functions */
	NV_GL_LOAD_EXT( glBlendEquationSeparate );
	NV_GL_LOAD_EXT( glDrawBuffers );
	NV_GL_LOAD_EXT( glStencilOpSeparate );
	NV_GL_LOAD_EXT( glStencilFuncSeparate );
	NV_GL_LOAD_EXT( glStencilMaskSeparate );
	NV_GL_LOAD_EXT( glAttachShader );
	NV_GL_LOAD_EXT( glBindAttribLocation );
	NV_GL_LOAD_EXT( glCompileShader );
	NV_GL_LOAD_EXT( glCreateProgram );
	NV_GL_LOAD_EXT( glCreateShader );
	NV_GL_LOAD_EXT( glDeleteProgram );
	NV_GL_LOAD_EXT( glDeleteShader );
	NV_GL_LOAD_EXT( glDetachShader );
	NV_GL_LOAD_EXT( glDisableVertexAttribArray );
	NV_GL_LOAD_EXT( glEnableVertexAttribArray );
	NV_GL_LOAD_EXT( glGetActiveAttrib );
	NV_GL_LOAD_EXT( glGetActiveUniform );
	NV_GL_LOAD_EXT( glGetAttachedShaders );
	NV_GL_LOAD_EXT( glGetAttribLocation );
	NV_GL_LOAD_EXT( glGetProgramiv );
	NV_GL_LOAD_EXT( glGetProgramInfoLog );
	NV_GL_LOAD_EXT( glGetShaderiv );
	NV_GL_LOAD_EXT( glGetShaderInfoLog );
	NV_GL_LOAD_EXT( glGetShaderSource );
	NV_GL_LOAD_EXT( glGetUniformLocation );
	NV_GL_LOAD_EXT( glGetUniformfv );
	NV_GL_LOAD_EXT( glGetUniformiv );
	NV_GL_LOAD_EXT( glGetVertexAttribdv );
	NV_GL_LOAD_EXT( glGetVertexAttribfv );
	NV_GL_LOAD_EXT( glGetVertexAttribiv );
	NV_GL_LOAD_EXT( glGetVertexAttribPointerv );
	NV_GL_LOAD_EXT( glIsProgram );
	NV_GL_LOAD_EXT( glIsShader );
	NV_GL_LOAD_EXT( glLinkProgram );
	NV_GL_LOAD_EXT( glShaderSource );
	NV_GL_LOAD_EXT( glUseProgram );
	NV_GL_LOAD_EXT( glUniform1f );
	NV_GL_LOAD_EXT( glUniform2f );
	NV_GL_LOAD_EXT( glUniform3f );
	NV_GL_LOAD_EXT( glUniform4f );
	NV_GL_LOAD_EXT( glUniform1i );
	NV_GL_LOAD_EXT( glUniform2i );
	NV_GL_LOAD_EXT( glUniform3i );
	NV_GL_LOAD_EXT( glUniform4i );
	NV_GL_LOAD_EXT( glUniform1fv );
	NV_GL_LOAD_EXT( glUniform2fv );
	NV_GL_LOAD_EXT( glUniform3fv );
	NV_GL_LOAD_EXT( glUniform4fv );
	NV_GL_LOAD_EXT( glUniform1iv );
	NV_GL_LOAD_EXT( glUniform2iv );
	NV_GL_LOAD_EXT( glUniform3iv );
	NV_GL_LOAD_EXT( glUniform4iv );
	NV_GL_LOAD_EXT( glUniformMatrix2fv );
	NV_GL_LOAD_EXT( glUniformMatrix3fv );
	NV_GL_LOAD_EXT( glUniformMatrix4fv );
	NV_GL_LOAD_EXT( glValidateProgram );
	NV_GL_LOAD_EXT( glVertexAttribPointer );

/* OpenGL 2.1 non-deprecated functions */
	NV_GL_LOAD_EXT( glUniformMatrix2x3fv );
	NV_GL_LOAD_EXT( glUniformMatrix3x2fv );
	NV_GL_LOAD_EXT( glUniformMatrix2x4fv );
	NV_GL_LOAD_EXT( glUniformMatrix4x2fv );
	NV_GL_LOAD_EXT( glUniformMatrix3x4fv );
	NV_GL_LOAD_EXT( glUniformMatrix4x3fv );

#	undef NV_GL_LOAD
#	undef NV_GL_LOAD_EXT
	return true;
}

#endif
