// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/freetype2.hh"

#if defined( NV_FREETYPE_DYNAMIC )

#include "nv/library.hh"

FT_Error (NV_FREETYPE_APIENTRY *FT_Init_FreeType) (  FT_Library  *alibrary  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Done_FreeType) (  FT_Library  library  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_New_Face) (  FT_Library library, const char*  filepathname, FT_Long face_index, FT_Face *aface  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_New_Memory_Face) (  FT_Library library, const FT_Byte*  file_base, FT_Long file_size, FT_Long face_index, FT_Face *aface  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Open_Face) (  FT_Library library, const FT_Open_Args*  args, FT_Long face_index, FT_Face *aface  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Attach_File) (  FT_Face face, const char*  filepathname  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Attach_Stream) (  FT_Face face, FT_Open_Args* parameters  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Reference_Face) (  FT_Face  face  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Done_Face) (  FT_Face  face  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Select_Size) (  FT_Face face, FT_Int strike_index  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Request_Size) (  FT_Face face, FT_Size_Request req  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Set_Char_Size) (  FT_Face face, FT_F26Dot6 char_width, FT_F26Dot6 char_height, FT_UInt horz_resolution, FT_UInt vert_resolution  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Set_Pixel_Sizes) (  FT_Face face, FT_UInt pixel_width, FT_UInt pixel_height  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Load_Glyph) (  FT_Face face, FT_UInt glyph_index, FT_Int32 load_flags  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Load_Char) (  FT_Face face, FT_ULong char_code, FT_Int32 load_flags  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Set_Transform) (  FT_Face face, FT_Matrix* matrix, FT_Vector* delta  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Render_Glyph) (  FT_GlyphSlot slot, FT_Render_Mode render_mode  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_Kerning) (  FT_Face face, FT_UInt left_glyph, FT_UInt right_glyph, FT_UInt kern_mode, FT_Vector *akerning  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_Track_Kerning) (  FT_Face face, FT_Fixed point_size, FT_Int degree, FT_Fixed* akerning  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_Glyph_Name) (  FT_Face face, FT_UInt glyph_index, FT_Pointer buffer, FT_UInt buffer_max  ) = nullptr;
const char* (NV_FREETYPE_APIENTRY *FT_Get_Postscript_Name) (  FT_Face face  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Select_Charmap) (  FT_Face face, FT_Encoding  encoding  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Set_Charmap) (  FT_Face face, FT_CharMap charmap  ) = nullptr;
FT_Int (NV_FREETYPE_APIENTRY *FT_Get_Charmap_Index) (  FT_CharMap charmap  ) = nullptr;
FT_UInt (NV_FREETYPE_APIENTRY *FT_Get_Char_Index) (  FT_Face face, FT_ULong charcode  ) = nullptr;
FT_ULong (NV_FREETYPE_APIENTRY *FT_Get_First_Char) (  FT_Face face, FT_UInt *agindex  ) = nullptr;
FT_ULong (NV_FREETYPE_APIENTRY *FT_Get_Next_Char) (  FT_Face face, FT_ULong char_code, FT_UInt *agindex  ) = nullptr;
FT_UInt (NV_FREETYPE_APIENTRY *FT_Get_Name_Index) (  FT_Face face, FT_String* glyph_name  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_SubGlyph_Info) (  FT_GlyphSlot glyph, FT_UInt sub_index, FT_Int *p_index, FT_UInt *p_flags, FT_Int *p_arg1, FT_Int *p_arg2, FT_Matrix *p_transform  ) = nullptr;
FT_UShort (NV_FREETYPE_APIENTRY *FT_Get_FSType_Flags) (  FT_Face  face  ) = nullptr;
FT_UInt (NV_FREETYPE_APIENTRY *FT_Face_GetCharVariantIndex) (  FT_Face face, FT_ULong charcode, FT_ULong variantSelector  ) = nullptr;
FT_Int (NV_FREETYPE_APIENTRY *FT_Face_GetCharVariantIsDefault) (  FT_Face face, FT_ULong charcode, FT_ULong variantSelector  ) = nullptr;
FT_UInt32* (NV_FREETYPE_APIENTRY *FT_Face_GetVariantSelectors) (  FT_Face face  ) = nullptr;
FT_UInt32* (NV_FREETYPE_APIENTRY *FT_Face_GetVariantsOfChar) (  FT_Face face, FT_ULong charcode  ) = nullptr;
FT_UInt32* (NV_FREETYPE_APIENTRY *FT_Face_GetCharsOfVariant) (  FT_Face face, FT_ULong variantSelector  ) = nullptr;
FT_Long (NV_FREETYPE_APIENTRY *FT_MulFix) (  FT_Long  a, FT_Long  b  ) = nullptr;
FT_Long (NV_FREETYPE_APIENTRY *FT_DivFix) (  FT_Long  a, FT_Long  b  ) = nullptr;
FT_Fixed (NV_FREETYPE_APIENTRY *FT_RoundFix) (  FT_Fixed  a  ) = nullptr;
FT_Fixed (NV_FREETYPE_APIENTRY *FT_CeilFix) (  FT_Fixed  a  ) = nullptr;
FT_Fixed (NV_FREETYPE_APIENTRY *FT_FloorFix) (  FT_Fixed  a  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Vector_Transform) (  FT_Vector* vec, const FT_Matrix*  matrix  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Library_Version) (  FT_Library library, FT_Int *amajor, FT_Int *aminor, FT_Int *apatch  ) = nullptr; 
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_Glyph) (  FT_GlyphSlot slot, FT_Glyph *aglyph  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Glyph_Copy) (  FT_Glyph source, FT_Glyph *target  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Glyph_Transform) (  FT_Glyph glyph, FT_Matrix* matrix, FT_Vector* delta  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Glyph_Get_CBox) (  FT_Glyph glyph, FT_UInt bbox_mode, FT_BBox  *acbox  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Glyph_To_Bitmap) (  FT_Glyph* the_glyph, FT_Render_Mode render_mode, FT_Vector* origin, FT_Bool destroy  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Done_Glyph) (  FT_Glyph  glyph  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Matrix_Multiply) (  const FT_Matrix*  a, FT_Matrix*        b  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Matrix_Invert) (  FT_Matrix*  matrix  ) = nullptr;
FT_Renderer (NV_FREETYPE_APIENTRY *FT_Get_Renderer) (  FT_Library library, FT_Glyph_Format format  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Set_Renderer) (  FT_Library library, FT_Renderer renderer, FT_UInt num_params, FT_Parameter* parameters  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Add_Module) (  FT_Library library, const FT_Module_Class*  clazz  ) = nullptr;
FT_Module (NV_FREETYPE_APIENTRY *FT_Get_Module) (  FT_Library library, const char*  module_name  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Remove_Module) (  FT_Library  library, FT_Module   module  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Reference_Library) (  FT_Library  library  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_New_Library) (  FT_Memory memory, FT_Library  *alibrary  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Done_Library) (  FT_Library  library  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Set_Debug_Hook) (  FT_Library library, FT_UInt hook_index, FT_DebugHook_Func  debug_hook  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Add_Default_Modules) (  FT_Library  library  ) = nullptr;
FT_TrueTypeEngineType (NV_FREETYPE_APIENTRY *FT_Get_TrueType_Engine_Type) (  FT_Library  library  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_Advance) (  FT_Face face, FT_UInt gindex, FT_Int32 load_flags, FT_Fixed *padvance  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_Advances) (  FT_Face face, FT_UInt start, FT_UInt count, FT_Int32 load_flags, FT_Fixed *padvances  ) = nullptr; 
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Decompose) (  FT_Outline* outline, const FT_Outline_Funcs*  func_interface, void* user  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_New) (  FT_Library library, FT_UInt numPoints, FT_Int numContours, FT_Outline  *anoutline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_New_Internal) (  FT_Memory memory, FT_UInt numPoints, FT_Int numContours, FT_Outline  *anoutline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Done) (  FT_Library library, FT_Outline*  outline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Done_Internal) (  FT_Memory memory, FT_Outline* outline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Check) (  FT_Outline*  outline  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Outline_Get_CBox) (  const FT_Outline* outline, FT_BBox *acbox  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Outline_Translate) (  const FT_Outline* outline, FT_Pos xOffset, FT_Pos yOffset  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Copy) (  const FT_Outline* source, FT_Outline *target  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Outline_Transform) (  const FT_Outline* outline, const FT_Matrix* matrix  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Embolden) (  FT_Outline* outline, FT_Pos strength  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Outline_Reverse) (  FT_Outline*  outline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Get_Bitmap) (  FT_Library library, FT_Outline* outline, const FT_Bitmap *abitmap  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Render) (  FT_Library library, FT_Outline* outline, FT_Raster_Params* params  ) = nullptr;
FT_Orientation (NV_FREETYPE_APIENTRY *FT_Outline_Get_Orientation) (  FT_Outline*  outline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Outline_Get_BBox) (  FT_Outline* outline, FT_BBox *abbox  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Bitmap_New) (  FT_Bitmap  *abitmap  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Bitmap_Copy) (  FT_Library library, const FT_Bitmap *source, FT_Bitmap *target  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Bitmap_Embolden) (  FT_Library library, FT_Bitmap* bitmap, FT_Pos xStrength, FT_Pos yStrength  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Bitmap_Convert) (  FT_Library library, const FT_Bitmap *source, FT_Bitmap *target, FT_Int alignment  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_GlyphSlot_Own_Bitmap) (  FT_GlyphSlot  slot  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Bitmap_Done) (  FT_Library library, FT_Bitmap *bitmap  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_BDF_Charset_ID) (  FT_Face face, const char* *acharset_encoding, const char* *acharset_registry  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_BDF_Property) (  FT_Face face, const char* prop_name, BDF_PropertyRec *aproperty  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_CID_Registry_Ordering_Supplement) (  FT_Face face, const char* *registry, const char* *ordering, FT_Int *supplement  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_CID_Is_Internally_CID_Keyed) (  FT_Face face, FT_Bool *is_cid  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_CID_From_Glyph_Index) (  FT_Face face, FT_UInt glyph_index, FT_UInt *cid  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_PFR_Metrics) (  FT_Face face, FT_UInt *aoutline_resolution, FT_UInt   *ametrics_resolution, FT_Fixed  *ametrics_x_scale, FT_Fixed  *ametrics_y_scale  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_PFR_Kerning) (  FT_Face face, FT_UInt left, FT_UInt right, FT_Vector  *avector  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_PFR_Advance) (  FT_Face face, FT_UInt gindex, FT_Pos *aadvance  ) = nullptr;
FT_Int (NV_FREETYPE_APIENTRY *FT_Get_Gasp) (  FT_Face face, FT_UInt ppem  ) = nullptr; 
FT_Error (NV_FREETYPE_APIENTRY *FT_New_Size) (  FT_Face face, FT_Size* size  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Done_Size) (  FT_Size size  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Activate_Size) (  FT_Size  size  ) = nullptr;
FT_UInt (NV_FREETYPE_APIENTRY *FT_Get_Sfnt_Name_Count) (  FT_Face  face  ) = nullptr; 
FT_Error (NV_FREETYPE_APIENTRY *FT_Get_Sfnt_Name) (  FT_Face face, FT_UInt idx, FT_SfntName  *aname  ) = nullptr;

FT_StrokerBorder (NV_FREETYPE_APIENTRY *FT_Outline_GetInsideBorder) (  FT_Outline* outline  ) = nullptr;
FT_StrokerBorder (NV_FREETYPE_APIENTRY *FT_Outline_GetOutsideBorder) (  FT_Outline* outline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_New) (  FT_Library library, FT_Stroker *astroker  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Stroker_Set) (  FT_Stroker stroker, FT_Fixed radius, FT_Stroker_LineCap line_cap, FT_Stroker_LineJoin line_join, FT_Fixed miter_limit  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Stroker_Rewind) (  FT_Stroker stroker  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_ParseOutline) (  FT_Stroker stroker, FT_Outline* outline, FT_Bool opened  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_BeginSubPath) (  FT_Stroker stroker, FT_Vector* to, FT_Bool open  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_EndSubPath) (  FT_Stroker stroker  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_LineTo) (  FT_Stroker stroker, FT_Vector* to  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_ConicTo) (  FT_Stroker stroker, FT_Vector* control, FT_Vector* to  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_CubicTo) (  FT_Stroker stroker, FT_Vector* control1, FT_Vector* control2, FT_Vector* to  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_GetBorderCounts) (  FT_Stroker stroker, FT_StrokerBorder border, FT_UInt *anum_points, FT_UInt *anum_contours  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Stroker_ExportBorder) (  FT_Stroker stroker, FT_StrokerBorder border, FT_Outline* outline  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Stroker_GetCounts) (  FT_Stroker stroker, FT_UInt *anum_points, FT_UInt *anum_contours  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Stroker_Export) (  FT_Stroker stroker, FT_Outline* outline  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Stroker_Done) (  FT_Stroker stroker  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Glyph_Stroke) (  FT_Glyph *pglyph, FT_Stroker stroker, FT_Bool destroy  ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Glyph_StrokeBorder) (  FT_Glyph *pglyph, FT_Stroker stroker, FT_Bool inside, FT_Bool destroy  ) = nullptr;

FT_Fixed (NV_FREETYPE_APIENTRY *FT_Sin) (  FT_Angle angle  ) = nullptr;
FT_Fixed (NV_FREETYPE_APIENTRY *FT_Cos) (  FT_Angle angle  ) = nullptr;
FT_Fixed (NV_FREETYPE_APIENTRY *FT_Tan) (  FT_Angle angle  ) = nullptr;
FT_Angle (NV_FREETYPE_APIENTRY *FT_Atan2) (  FT_Fixed x, FT_Fixed  y  ) = nullptr;
FT_Angle (NV_FREETYPE_APIENTRY *FT_Angle_Diff) (  FT_Angle angle1, FT_Angle  angle2  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Vector_Unit) (  FT_Vector* vec, FT_Angle angle  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Vector_Rotate) (  FT_Vector* vec, FT_Angle angle  ) = nullptr;
FT_Fixed (NV_FREETYPE_APIENTRY *FT_Vector_Length) (  FT_Vector* vec  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Vector_Polarize) (  FT_Vector* vec, FT_Fixed *length, FT_Angle *angle  ) = nullptr;
void (NV_FREETYPE_APIENTRY *FT_Vector_From_Polar) (  FT_Vector* vec, FT_Fixed length, FT_Angle angle  ) = nullptr;

FT_Error (NV_FREETYPE_APIENTRY *FT_Library_SetLcdFilter) ( FT_Library library, FT_LcdFilter  filter ) = nullptr;
FT_Error (NV_FREETYPE_APIENTRY *FT_Library_SetLcdFilterWeights) ( FT_Library library, unsigned char *weights ) = nullptr;


bool nv::load_freetype_library( const char* path )
{
#	define NV_FREETYPE_LOAD( symbol ) *(void **) (&symbol) = freetype_library.get(#symbol);
	static nv::library freetype_library;
	if ( freetype_library.is_open() ) return true;
	freetype_library.open( path );

	NV_FREETYPE_LOAD( FT_Init_FreeType );
	NV_FREETYPE_LOAD( FT_Done_FreeType );
	NV_FREETYPE_LOAD( FT_New_Face );
	NV_FREETYPE_LOAD( FT_New_Memory_Face );
	NV_FREETYPE_LOAD( FT_Open_Face );
	NV_FREETYPE_LOAD( FT_Attach_File );
	NV_FREETYPE_LOAD( FT_Attach_Stream );
	NV_FREETYPE_LOAD( FT_Reference_Face );
	NV_FREETYPE_LOAD( FT_Done_Face );
	NV_FREETYPE_LOAD( FT_Select_Size );
	NV_FREETYPE_LOAD( FT_Request_Size );
	NV_FREETYPE_LOAD( FT_Set_Char_Size );
	NV_FREETYPE_LOAD( FT_Set_Pixel_Sizes );
	NV_FREETYPE_LOAD( FT_Load_Glyph );
	NV_FREETYPE_LOAD( FT_Load_Char );
	NV_FREETYPE_LOAD( FT_Set_Transform );
	NV_FREETYPE_LOAD( FT_Render_Glyph );
	NV_FREETYPE_LOAD( FT_Get_Kerning );
	NV_FREETYPE_LOAD( FT_Get_Track_Kerning );
	NV_FREETYPE_LOAD( FT_Get_Glyph_Name );
	NV_FREETYPE_LOAD( FT_Get_Postscript_Name );
	NV_FREETYPE_LOAD( FT_Select_Charmap );
	NV_FREETYPE_LOAD( FT_Set_Charmap );
	NV_FREETYPE_LOAD( FT_Get_Charmap_Index );
	NV_FREETYPE_LOAD( FT_Get_Char_Index );
	NV_FREETYPE_LOAD( FT_Get_First_Char );
	NV_FREETYPE_LOAD( FT_Get_Next_Char );
	NV_FREETYPE_LOAD( FT_Get_Name_Index );
	NV_FREETYPE_LOAD( FT_Get_SubGlyph_Info );
	NV_FREETYPE_LOAD( FT_Get_FSType_Flags );
	NV_FREETYPE_LOAD( FT_Face_GetCharVariantIndex );
	NV_FREETYPE_LOAD( FT_Face_GetCharVariantIsDefault );
	NV_FREETYPE_LOAD( FT_Face_GetVariantSelectors );
	NV_FREETYPE_LOAD( FT_Face_GetVariantsOfChar );
	NV_FREETYPE_LOAD( FT_Face_GetCharsOfVariant );
	NV_FREETYPE_LOAD( FT_MulFix );
	NV_FREETYPE_LOAD( FT_DivFix );
	NV_FREETYPE_LOAD( FT_RoundFix );
	NV_FREETYPE_LOAD( FT_CeilFix );
	NV_FREETYPE_LOAD( FT_FloorFix );
	NV_FREETYPE_LOAD( FT_Vector_Transform );
	NV_FREETYPE_LOAD( FT_Library_Version ); 
	NV_FREETYPE_LOAD( FT_Get_Glyph );
	NV_FREETYPE_LOAD( FT_Glyph_Copy );
	NV_FREETYPE_LOAD( FT_Glyph_Transform );
	NV_FREETYPE_LOAD( FT_Glyph_Get_CBox );
	NV_FREETYPE_LOAD( FT_Glyph_To_Bitmap );
	NV_FREETYPE_LOAD( FT_Done_Glyph );
	NV_FREETYPE_LOAD( FT_Matrix_Multiply );
	NV_FREETYPE_LOAD( FT_Matrix_Invert );
	NV_FREETYPE_LOAD( FT_Get_Renderer );
	NV_FREETYPE_LOAD( FT_Set_Renderer );
	NV_FREETYPE_LOAD( FT_Add_Module );
	NV_FREETYPE_LOAD( FT_Get_Module );
	NV_FREETYPE_LOAD( FT_Remove_Module );
	NV_FREETYPE_LOAD( FT_Reference_Library );
	NV_FREETYPE_LOAD( FT_New_Library );
	NV_FREETYPE_LOAD( FT_Done_Library );
	NV_FREETYPE_LOAD( FT_Set_Debug_Hook );
	NV_FREETYPE_LOAD( FT_Add_Default_Modules );
	NV_FREETYPE_LOAD( FT_Get_TrueType_Engine_Type );
	NV_FREETYPE_LOAD( FT_Get_Advance );
	NV_FREETYPE_LOAD( FT_Get_Advances ); 
	NV_FREETYPE_LOAD( FT_Outline_Decompose );
	NV_FREETYPE_LOAD( FT_Outline_New );
	NV_FREETYPE_LOAD( FT_Outline_New_Internal );
	NV_FREETYPE_LOAD( FT_Outline_Done );
	NV_FREETYPE_LOAD( FT_Outline_Done_Internal );
	NV_FREETYPE_LOAD( FT_Outline_Check );
	NV_FREETYPE_LOAD( FT_Outline_Get_CBox );
	NV_FREETYPE_LOAD( FT_Outline_Translate );
	NV_FREETYPE_LOAD( FT_Outline_Copy );
	NV_FREETYPE_LOAD( FT_Outline_Transform );
	NV_FREETYPE_LOAD( FT_Outline_Embolden );
	NV_FREETYPE_LOAD( FT_Outline_Reverse );
	NV_FREETYPE_LOAD( FT_Outline_Get_Bitmap );
	NV_FREETYPE_LOAD( FT_Outline_Render );
	NV_FREETYPE_LOAD( FT_Outline_Get_Orientation );
	NV_FREETYPE_LOAD( FT_Outline_Get_BBox );
	NV_FREETYPE_LOAD( FT_Bitmap_New );
	NV_FREETYPE_LOAD( FT_Bitmap_Copy );
	NV_FREETYPE_LOAD( FT_Bitmap_Embolden );
	NV_FREETYPE_LOAD( FT_Bitmap_Convert );
	NV_FREETYPE_LOAD( FT_GlyphSlot_Own_Bitmap );
	NV_FREETYPE_LOAD( FT_Bitmap_Done );
	NV_FREETYPE_LOAD( FT_Get_BDF_Charset_ID );
	NV_FREETYPE_LOAD( FT_Get_BDF_Property );
	NV_FREETYPE_LOAD( FT_Get_CID_Registry_Ordering_Supplement );
	NV_FREETYPE_LOAD( FT_Get_CID_Is_Internally_CID_Keyed );
	NV_FREETYPE_LOAD( FT_Get_CID_From_Glyph_Index );
	NV_FREETYPE_LOAD( FT_Get_PFR_Metrics );
	NV_FREETYPE_LOAD( FT_Get_PFR_Kerning );
	NV_FREETYPE_LOAD( FT_Get_PFR_Advance );
	NV_FREETYPE_LOAD( FT_Get_Gasp ); 
	NV_FREETYPE_LOAD( FT_New_Size );
	NV_FREETYPE_LOAD( FT_Done_Size );
	NV_FREETYPE_LOAD( FT_Activate_Size );
	NV_FREETYPE_LOAD( FT_Get_Sfnt_Name_Count ); 
	NV_FREETYPE_LOAD( FT_Get_Sfnt_Name );

	NV_FREETYPE_LOAD( FT_Outline_GetInsideBorder );
	NV_FREETYPE_LOAD( FT_Outline_GetOutsideBorder );
	NV_FREETYPE_LOAD( FT_Stroker_New );
	NV_FREETYPE_LOAD( FT_Stroker_Set );
	NV_FREETYPE_LOAD( FT_Stroker_Rewind );
	NV_FREETYPE_LOAD( FT_Stroker_ParseOutline );
	NV_FREETYPE_LOAD( FT_Stroker_BeginSubPath );
	NV_FREETYPE_LOAD( FT_Stroker_EndSubPath );
	NV_FREETYPE_LOAD( FT_Stroker_LineTo );
	NV_FREETYPE_LOAD( FT_Stroker_ConicTo );
	NV_FREETYPE_LOAD( FT_Stroker_CubicTo );
	NV_FREETYPE_LOAD( FT_Stroker_GetBorderCounts );
	NV_FREETYPE_LOAD( FT_Stroker_ExportBorder );
	NV_FREETYPE_LOAD( FT_Stroker_GetCounts );
	NV_FREETYPE_LOAD( FT_Stroker_Export );
	NV_FREETYPE_LOAD( FT_Stroker_Done );
	NV_FREETYPE_LOAD( FT_Glyph_Stroke );
	NV_FREETYPE_LOAD( FT_Glyph_StrokeBorder );

	NV_FREETYPE_LOAD( FT_Sin );
	NV_FREETYPE_LOAD( FT_Cos );
	NV_FREETYPE_LOAD( FT_Tan );
	NV_FREETYPE_LOAD( FT_Atan2 );
	NV_FREETYPE_LOAD( FT_Angle_Diff );
	NV_FREETYPE_LOAD( FT_Vector_Unit );
	NV_FREETYPE_LOAD( FT_Vector_Rotate );
	NV_FREETYPE_LOAD( FT_Vector_Length );
	NV_FREETYPE_LOAD( FT_Vector_Polarize );
	NV_FREETYPE_LOAD( FT_Vector_From_Polar );
	NV_FREETYPE_LOAD( FT_Library_SetLcdFilter );
	NV_FREETYPE_LOAD( FT_Library_SetLcdFilterWeights );

#	undef NV_FREETYPE_LOAD
	return true;
}
#endif
