// Copyright (C) 2012-2013 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/gl/gl_names.hh"

#include "nv/lib/gl.hh"

using namespace nv;

gl_texture_name::gl_texture_name()
{
	glGenTextures( 1, &m_value );
}

gl_texture_name::~gl_texture_name()
{
	if ( m_value != 0 )
	{
		glDeleteTextures( 1, &m_value );
	}
}

gl_shader_name::gl_shader_name()
{
	m_value = glCreateProgram();
}

gl_shader_name::~gl_shader_name()
{
	if ( m_value != 0 )
	{
		glDeleteProgram( m_value );
	}
}

gl_buffer_name::gl_buffer_name()
{
	glGenBuffers( 1, &m_value );
}

gl_buffer_name::~gl_buffer_name()
{
	if ( m_value != 0 )
	{
		glDeleteBuffers( 1, &m_value );
	}
}
