// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file std_stream.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief stream adapter for usage with STL
 */

#ifndef NV_STD_STREAM_HH
#define NV_STD_STREAM_HH

#include <nv/common.hh>
#include <nv/interface/stream.hh>
#include <streambuf>
#include <vector>

namespace nv
{
	class std_stream : public std::streambuf
	{
	public:
		explicit std_stream( stream* source, bool owner = false, std::size_t bsize = 256, std::size_t put_back = 8 );
		~std_stream();
	protected:
		stream*           m_stream;
		bool              m_owner;
		std::vector<char> m_buffer;
		std::size_t       m_put_back;
	private:
		std_stream( const std_stream& );             // dissalow copy
		std_stream *operator =( const std_stream& ); // dissalow assign
		int_type underflow();
	};

} // namespace nv

#endif // NV_STD_STREAM_HH
