// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/sdl12.hh"

#if defined( NV_SDL_DYNAMIC )

#include "nv/library.hh"

/* SDL.h functions */
int (NV_SDL_APIENTRY *SDL_Init) (Uint32 flags) = nullptr;
int (NV_SDL_APIENTRY *SDL_InitSubSystem) (Uint32 flags) = nullptr;
void (NV_SDL_APIENTRY *SDL_QuitSubSystem) (Uint32 flags) = nullptr;
Uint32 (NV_SDL_APIENTRY *SDL_WasInit) (Uint32 flags) = nullptr;
void (NV_SDL_APIENTRY *SDL_Quit) (void) = nullptr;

/* SDL_rwops.h functions */
SDL_RWops * (NV_SDL_APIENTRY *SDL_RWFromFile) (const char *file, const char *mode) = nullptr;
SDL_RWops * (NV_SDL_APIENTRY *SDL_RWFromFP) (FILE *fp, int autoclose) = nullptr;
SDL_RWops * (NV_SDL_APIENTRY *SDL_RWFromMem) (void *mem, int size) = nullptr;
SDL_RWops * (NV_SDL_APIENTRY *SDL_RWFromConstMem) (const void *mem, int size) = nullptr;
SDL_RWops * (NV_SDL_APIENTRY *SDL_AllocRW) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_FreeRW) (SDL_RWops *area) = nullptr;
Uint16 (NV_SDL_APIENTRY *SDL_ReadLE16) (SDL_RWops *src) = nullptr;
Uint16 (NV_SDL_APIENTRY *SDL_ReadBE16) (SDL_RWops *src) = nullptr;
Uint32 (NV_SDL_APIENTRY *SDL_ReadLE32) (SDL_RWops *src) = nullptr;
Uint32 (NV_SDL_APIENTRY *SDL_ReadBE32) (SDL_RWops *src) = nullptr;
Uint64 (NV_SDL_APIENTRY *SDL_ReadLE64) (SDL_RWops *src) = nullptr;
Uint64 (NV_SDL_APIENTRY *SDL_ReadBE64) (SDL_RWops *src) = nullptr;
int (NV_SDL_APIENTRY *SDL_WriteLE16) (SDL_RWops *dst, Uint16 value) = nullptr;
int (NV_SDL_APIENTRY *SDL_WriteBE16) (SDL_RWops *dst, Uint16 value) = nullptr;
int (NV_SDL_APIENTRY *SDL_WriteLE32) (SDL_RWops *dst, Uint32 value) = nullptr;
int (NV_SDL_APIENTRY *SDL_WriteBE32) (SDL_RWops *dst, Uint32 value) = nullptr;
int (NV_SDL_APIENTRY *SDL_WriteLE64) (SDL_RWops *dst, Uint64 value) = nullptr;
int (NV_SDL_APIENTRY *SDL_WriteBE64) (SDL_RWops *dst, Uint64 value) = nullptr;

/* SDL_video.h defines */
int (NV_SDL_APIENTRY *SDL_VideoInit) (const char *driver_name, Uint32 flags) = nullptr;
void (NV_SDL_APIENTRY *SDL_VideoQuit) (void) = nullptr;
char * (NV_SDL_APIENTRY *SDL_VideoDriverName) (char *namebuf, int maxlen) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_GetVideoSurface) (void) = nullptr;
const SDL_VideoInfo * (NV_SDL_APIENTRY *SDL_GetVideoInfo) (void) = nullptr;
int (NV_SDL_APIENTRY *SDL_VideoModeOK) (int width, int height, int bpp, Uint32 flags) = nullptr;
SDL_Rect ** (NV_SDL_APIENTRY *SDL_ListModes) (SDL_PixelFormat *format, Uint32 flags) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_SetVideoMode) (int width, int height, int bpp, Uint32 flags) = nullptr;
void (NV_SDL_APIENTRY *SDL_UpdateRects) (SDL_Surface *screen, int numrects, SDL_Rect *rects) = nullptr;
void (NV_SDL_APIENTRY *SDL_UpdateRect) (SDL_Surface *screen, Sint32 x, Sint32 y, Uint32 w, Uint32 h) = nullptr;
int (NV_SDL_APIENTRY *SDL_Flip) (SDL_Surface *screen) = nullptr;
int (NV_SDL_APIENTRY *SDL_SetGamma) (float red, float green, float blue) = nullptr;
int (NV_SDL_APIENTRY *SDL_SetGammaRamp) (const Uint16 *red, const Uint16 *green, const Uint16 *blue) = nullptr;
int (NV_SDL_APIENTRY *SDL_GetGammaRamp) (Uint16 *red, Uint16 *green, Uint16 *blue) = nullptr;
int (NV_SDL_APIENTRY *SDL_SetColors) (SDL_Surface *surface, SDL_Color *colors, int firstcolor, int ncolors) = nullptr;
int (NV_SDL_APIENTRY *SDL_SetPalette) (SDL_Surface *surface, int flags, SDL_Color *colors, int firstcolor, int ncolors) = nullptr;
Uint32 (NV_SDL_APIENTRY *SDL_MapRGB) (const SDL_PixelFormat * const format, const Uint8 r, const Uint8 g, const Uint8 b) = nullptr;
Uint32 (NV_SDL_APIENTRY *SDL_MapRGBA) (const SDL_PixelFormat * const format, const Uint8 r, const Uint8 g, const Uint8 b, const Uint8 a) = nullptr;
void (NV_SDL_APIENTRY *SDL_GetRGB) (Uint32 pixel, const SDL_PixelFormat * const fmt, Uint8 *r, Uint8 *g, Uint8 *b) = nullptr;
void (NV_SDL_APIENTRY *SDL_GetRGBA) (Uint32 pixel,	const SDL_PixelFormat * const fmt, Uint8 *r, Uint8 *g, Uint8 *b, Uint8 *a) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_CreateRGBSurface) (Uint32 flags, int width, int height, int depth, Uint32 Rmask, Uint32 Gmask, Uint32 Bmask, Uint32 Amask) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_CreateRGBSurfaceFrom) (void *pixels, int width, int height, int depth, int pitch, Uint32 Rmask, Uint32 Gmask, Uint32 Bmask, Uint32 Amask) = nullptr;
void (NV_SDL_APIENTRY *SDL_FreeSurface) (SDL_Surface *surface) = nullptr;
int (NV_SDL_APIENTRY *SDL_LockSurface) (SDL_Surface *surface) = nullptr;
void (NV_SDL_APIENTRY *SDL_UnlockSurface) (SDL_Surface *surface) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_LoadBMP_RW) (SDL_RWops *src, int freesrc) = nullptr;
int (NV_SDL_APIENTRY *SDL_SaveBMP_RW) (SDL_Surface *surface, SDL_RWops *dst, int freedst) = nullptr;
int (NV_SDL_APIENTRY *SDL_SetColorKey) (SDL_Surface *surface, Uint32 flag, Uint32 key) = nullptr;
int (NV_SDL_APIENTRY *SDL_SetAlpha) (SDL_Surface *surface, Uint32 flag, Uint8 alpha) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_SetClipRect) (SDL_Surface *surface, const SDL_Rect *rect) = nullptr;
void (NV_SDL_APIENTRY *SDL_GetClipRect) (SDL_Surface *surface, SDL_Rect *rect) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_ConvertSurface) (SDL_Surface *src, SDL_PixelFormat *fmt, Uint32 flags) = nullptr;
int (NV_SDL_APIENTRY *SDL_UpperBlit) (SDL_Surface *src, SDL_Rect *srcrect, SDL_Surface *dst, SDL_Rect *dstrect) = nullptr;
int (NV_SDL_APIENTRY *SDL_LowerBlit) (SDL_Surface *src, SDL_Rect *srcrect, SDL_Surface *dst, SDL_Rect *dstrect) = nullptr;
int (NV_SDL_APIENTRY *SDL_FillRect) (SDL_Surface *dst, SDL_Rect *dstrect, Uint32 color) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_DisplayFormat) (SDL_Surface *surface) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *SDL_DisplayFormatAlpha) (SDL_Surface *surface) = nullptr;
SDL_Overlay * (NV_SDL_APIENTRY *SDL_CreateYUVOverlay) (int width, int height, Uint32 format, SDL_Surface *display) = nullptr;
int (NV_SDL_APIENTRY *SDL_LockYUVOverlay) (SDL_Overlay *overlay) = nullptr;
void (NV_SDL_APIENTRY *SDL_UnlockYUVOverlay) (SDL_Overlay *overlay) = nullptr;
int (NV_SDL_APIENTRY *SDL_DisplayYUVOverlay) (SDL_Overlay *overlay, SDL_Rect *dstrect) = nullptr;
void (NV_SDL_APIENTRY *SDL_FreeYUVOverlay) (SDL_Overlay *overlay) = nullptr;
int (NV_SDL_APIENTRY *SDL_GL_LoadLibrary) (const char *path) = nullptr;
void * (NV_SDL_APIENTRY *SDL_GL_GetProcAddress) (const char* proc) = nullptr;
int (NV_SDL_APIENTRY *SDL_GL_SetAttribute) (SDL_GLattr attr, int value) = nullptr;
int (NV_SDL_APIENTRY *SDL_GL_GetAttribute) (SDL_GLattr attr, int* value) = nullptr;
void (NV_SDL_APIENTRY *SDL_GL_SwapBuffers) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_GL_UpdateRects) (int numrects, SDL_Rect* rects) = nullptr;
void (NV_SDL_APIENTRY *SDL_GL_Lock) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_GL_Unlock) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_WM_SetCaption) (const char *title, const char *icon) = nullptr;
void (NV_SDL_APIENTRY *SDL_WM_GetCaption) (char **title, char **icon) = nullptr;
void (NV_SDL_APIENTRY *SDL_WM_SetIcon) (SDL_Surface *icon, Uint8 *mask) = nullptr;
int (NV_SDL_APIENTRY *SDL_WM_IconifyWindow) (void) = nullptr;
int (NV_SDL_APIENTRY *SDL_WM_ToggleFullScreen) (SDL_Surface *surface) = nullptr;
SDL_GrabMode (NV_SDL_APIENTRY *SDL_WM_GrabInput) (SDL_GrabMode mode) = nullptr; 

/* SDL_audio.h functions */
int (NV_SDL_APIENTRY *SDL_AudioInit) (const char *driver_name) = nullptr;
void (NV_SDL_APIENTRY *SDL_AudioQuit) (void) = nullptr; 
char * (NV_SDL_APIENTRY *SDL_AudioDriverName) (char *namebuf, int maxlen) = nullptr;
int (NV_SDL_APIENTRY *SDL_OpenAudio) (SDL_AudioSpec *desired, SDL_AudioSpec *obtained) = nullptr;
SDL_audiostatus (NV_SDL_APIENTRY *SDL_GetAudioStatus) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_PauseAudio) (int pause_on) = nullptr;
SDL_AudioSpec * (NV_SDL_APIENTRY *SDL_LoadWAV_RW) (SDL_RWops *src, int freesrc, SDL_AudioSpec *spec, Uint8 **audio_buf, Uint32 *audio_len) = nullptr;
void (NV_SDL_APIENTRY *SDL_FreeWAV) (Uint8 *audio_buf) = nullptr;
int (NV_SDL_APIENTRY *SDL_BuildAudioCVT) (SDL_AudioCVT *cvt, Uint16 src_format, Uint8 src_channels, int src_rate, Uint16 dst_format, Uint8 dst_channels, int dst_rate) = nullptr;
int (NV_SDL_APIENTRY *SDL_ConvertAudio) (SDL_AudioCVT *cvt) = nullptr;
void (NV_SDL_APIENTRY *SDL_MixAudio) (Uint8 *dst, const Uint8 *src, Uint32 len, int volume) = nullptr;
void (NV_SDL_APIENTRY *SDL_LockAudio) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_UnlockAudio) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_CloseAudio) (void) = nullptr;  

/* SDL_cpuinfo.h functions */
SDL_bool (NV_SDL_APIENTRY *SDL_HasRDTSC) (void) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_HasMMX) (void) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_HasMMXExt) (void) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_Has3DNow) (void) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_Has3DNowExt) (void) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_HasSSE) (void) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_HasSSE2) (void) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_HasAltiVec) (void) = nullptr; 

/* SDL_error.h functions */
void (NV_SDL_APIENTRY *SDL_SetError) (const char *fmt, ...) = nullptr;
char * (NV_SDL_APIENTRY *SDL_GetError) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_ClearError) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_Error) (SDL_errorcode code) = nullptr;

/* SDL_active.h functions */
Uint8 (NV_SDL_APIENTRY *SDL_GetAppState) (void) = nullptr;

/* SDL_keyboard.h functions */
int (NV_SDL_APIENTRY *SDL_EnableUNICODE) (int enable) = nullptr;
int (NV_SDL_APIENTRY *SDL_EnableKeyRepeat) (int delay, int interval) = nullptr;
void (NV_SDL_APIENTRY *SDL_GetKeyRepeat) (int *delay, int *interval) = nullptr;
Uint8 * (NV_SDL_APIENTRY *SDL_GetKeyState) (int *numkeys) = nullptr;
SDLMod (NV_SDL_APIENTRY *SDL_GetModState) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_SetModState) (SDLMod modstate) = nullptr;
char * (NV_SDL_APIENTRY *SDL_GetKeyName) (SDLKey key) = nullptr;
 
/* SDL_mouse.h functions */
Uint8 (NV_SDL_APIENTRY *SDL_GetMouseState) (int *x, int *y) = nullptr;
Uint8 (NV_SDL_APIENTRY *SDL_GetRelativeMouseState) (int *x, int *y) = nullptr;
void (NV_SDL_APIENTRY *SDL_WarpMouse) (Uint16 x, Uint16 y) = nullptr;
SDL_Cursor * (NV_SDL_APIENTRY *SDL_CreateCursor) (Uint8 *data, Uint8 *mask, int w, int h, int hot_x, int hot_y) = nullptr;
void (NV_SDL_APIENTRY *SDL_SetCursor) (SDL_Cursor *cursor) = nullptr;
SDL_Cursor * (NV_SDL_APIENTRY *SDL_GetCursor) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_FreeCursor) (SDL_Cursor *cursor) = nullptr;
int (NV_SDL_APIENTRY *SDL_ShowCursor) (int toggle) = nullptr;

/* SDL_joystick.h functions */
int (NV_SDL_APIENTRY *SDL_NumJoysticks) (void) = nullptr;
const char * (NV_SDL_APIENTRY *SDL_JoystickName) (int device_index) = nullptr;
SDL_Joystick * (NV_SDL_APIENTRY *SDL_JoystickOpen) (int device_index) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickOpened) (int device_index) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickIndex) (SDL_Joystick *joystick) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickNumAxes) (SDL_Joystick *joystick) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickNumBalls) (SDL_Joystick *joystick) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickNumHats) (SDL_Joystick *joystick) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickNumButtons) (SDL_Joystick *joystick) = nullptr;
void (NV_SDL_APIENTRY *SDL_JoystickUpdate) (void) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickEventState) (int state) = nullptr;
Sint16 (NV_SDL_APIENTRY *SDL_JoystickGetAxis) (SDL_Joystick *joystick, int axis) = nullptr;
Uint8 (NV_SDL_APIENTRY *SDL_JoystickGetHat) (SDL_Joystick *joystick, int hat) = nullptr;
int (NV_SDL_APIENTRY *SDL_JoystickGetBall) (SDL_Joystick *joystick, int ball, int *dx, int *dy) = nullptr;
Uint8 (NV_SDL_APIENTRY *SDL_JoystickGetButton) (SDL_Joystick *joystick, int button) = nullptr;
void (NV_SDL_APIENTRY *SDL_JoystickClose) (SDL_Joystick *joystick) = nullptr;

/* SDL_event.h functions */
void (NV_SDL_APIENTRY *SDL_PumpEvents) (void) = nullptr;
int (NV_SDL_APIENTRY *SDL_PeepEvents) (SDL_Event *events, int numevents, SDL_eventaction action, Uint32 mask)  = nullptr;
int (NV_SDL_APIENTRY *SDL_PollEvent) (SDL_Event *event) = nullptr;
int (NV_SDL_APIENTRY *SDL_WaitEvent) (SDL_Event *event) = nullptr;
int (NV_SDL_APIENTRY *SDL_PushEvent) (SDL_Event *event) = nullptr;
void (NV_SDL_APIENTRY *SDL_SetEventFilter) (SDL_EventFilter filter) = nullptr;
SDL_EventFilter (NV_SDL_APIENTRY *SDL_GetEventFilter) (void) = nullptr;
Uint8 (NV_SDL_APIENTRY *SDL_EventState) (Uint8 type, int state) = nullptr;

/* SDL_timer.h functions */
Uint32 (NV_SDL_APIENTRY *SDL_GetTicks) (void) = nullptr;
void (NV_SDL_APIENTRY *SDL_Delay) (Uint32 ms) = nullptr;
int (NV_SDL_APIENTRY *SDL_SetTimer) (Uint32 interval, SDL_TimerCallback callback) = nullptr;
SDL_TimerID (NV_SDL_APIENTRY *SDL_AddTimer) (Uint32 interval, SDL_NewTimerCallback callback, void *param) = nullptr;
SDL_bool (NV_SDL_APIENTRY *SDL_RemoveTimer) (SDL_TimerID t) = nullptr;

/* SDL_version.h functions */
const SDL_version * (NV_SDL_APIENTRY *SDL_Linked_Version) (void) = nullptr; 

bool nv::load_sdl_library( const char* path )
{
#	define NV_SDL_LOAD( symbol ) *(void **) (&symbol) = sdl_library.get(#symbol);
	static nv::library sdl_library;
	if ( sdl_library.is_open() ) return true;
	sdl_library.open( path );

/* SDL.h functions */
	NV_SDL_LOAD( SDL_Init );
	NV_SDL_LOAD( SDL_InitSubSystem );
	NV_SDL_LOAD( SDL_QuitSubSystem );
	NV_SDL_LOAD( SDL_WasInit );
	NV_SDL_LOAD( SDL_Quit );

/* SDL_rwops.h functions */
	NV_SDL_LOAD( SDL_RWFromFile );
	NV_SDL_LOAD( SDL_RWFromFP );
	NV_SDL_LOAD( SDL_RWFromMem );
	NV_SDL_LOAD( SDL_RWFromConstMem );
	NV_SDL_LOAD( SDL_AllocRW );
	NV_SDL_LOAD( SDL_FreeRW );
	NV_SDL_LOAD( SDL_ReadLE16 );
	NV_SDL_LOAD( SDL_ReadBE16 );
	NV_SDL_LOAD( SDL_ReadLE32 );
	NV_SDL_LOAD( SDL_ReadBE32 );
	NV_SDL_LOAD( SDL_ReadLE64 );
	NV_SDL_LOAD( SDL_ReadBE64 );
	NV_SDL_LOAD( SDL_WriteLE16 );
	NV_SDL_LOAD( SDL_WriteBE16 );
	NV_SDL_LOAD( SDL_WriteLE32 );
	NV_SDL_LOAD( SDL_WriteBE32 );
	NV_SDL_LOAD( SDL_WriteLE64 );
	NV_SDL_LOAD( SDL_WriteBE64 );

/* SDL_video.h defines */
	NV_SDL_LOAD( SDL_VideoInit );
	NV_SDL_LOAD( SDL_VideoQuit );
	NV_SDL_LOAD( SDL_VideoDriverName );
	NV_SDL_LOAD( SDL_GetVideoSurface );
	NV_SDL_LOAD( SDL_GetVideoInfo );
	NV_SDL_LOAD( SDL_VideoModeOK );
	NV_SDL_LOAD( SDL_ListModes );
	NV_SDL_LOAD( SDL_SetVideoMode );
	NV_SDL_LOAD( SDL_UpdateRects );
	NV_SDL_LOAD( SDL_UpdateRect );
	NV_SDL_LOAD( SDL_Flip );
	NV_SDL_LOAD( SDL_SetGamma );
	NV_SDL_LOAD( SDL_SetGammaRamp );
	NV_SDL_LOAD( SDL_GetGammaRamp );
	NV_SDL_LOAD( SDL_SetColors );
	NV_SDL_LOAD( SDL_SetPalette );
	NV_SDL_LOAD( SDL_MapRGB );
	NV_SDL_LOAD( SDL_MapRGBA );
	NV_SDL_LOAD( SDL_GetRGB );
	NV_SDL_LOAD( SDL_GetRGBA );
	NV_SDL_LOAD( SDL_CreateRGBSurface );
	NV_SDL_LOAD( SDL_CreateRGBSurfaceFrom );
	NV_SDL_LOAD( SDL_FreeSurface );
	NV_SDL_LOAD( SDL_LockSurface );
	NV_SDL_LOAD( SDL_UnlockSurface );
	NV_SDL_LOAD( SDL_LoadBMP_RW );
	NV_SDL_LOAD( SDL_SaveBMP_RW );
	NV_SDL_LOAD( SDL_SetColorKey );
	NV_SDL_LOAD( SDL_SetAlpha );
	NV_SDL_LOAD( SDL_SetClipRect );
	NV_SDL_LOAD( SDL_GetClipRect );
	NV_SDL_LOAD( SDL_ConvertSurface );
	NV_SDL_LOAD( SDL_UpperBlit );
	NV_SDL_LOAD( SDL_LowerBlit );
	NV_SDL_LOAD( SDL_FillRect );
	NV_SDL_LOAD( SDL_DisplayFormat );
	NV_SDL_LOAD( SDL_DisplayFormatAlpha );
	NV_SDL_LOAD( SDL_CreateYUVOverlay );
	NV_SDL_LOAD( SDL_LockYUVOverlay );
	NV_SDL_LOAD( SDL_UnlockYUVOverlay );
	NV_SDL_LOAD( SDL_DisplayYUVOverlay );
	NV_SDL_LOAD( SDL_FreeYUVOverlay );
	NV_SDL_LOAD( SDL_GL_LoadLibrary );
	NV_SDL_LOAD( SDL_GL_GetProcAddress );
	NV_SDL_LOAD( SDL_GL_SetAttribute );
	NV_SDL_LOAD( SDL_GL_GetAttribute );
	NV_SDL_LOAD( SDL_GL_SwapBuffers );
	NV_SDL_LOAD( SDL_GL_UpdateRects );
	NV_SDL_LOAD( SDL_GL_Lock );
	NV_SDL_LOAD( SDL_GL_Unlock );
	NV_SDL_LOAD( SDL_WM_SetCaption );
	NV_SDL_LOAD( SDL_WM_GetCaption );
	NV_SDL_LOAD( SDL_WM_SetIcon );
	NV_SDL_LOAD( SDL_WM_IconifyWindow );
	NV_SDL_LOAD( SDL_WM_ToggleFullScreen );
	NV_SDL_LOAD( SDL_WM_GrabInput ); 

/* SDL_audio.h functions */
	NV_SDL_LOAD( SDL_AudioInit );
	NV_SDL_LOAD( SDL_AudioQuit ); 
	NV_SDL_LOAD( SDL_AudioDriverName );
	NV_SDL_LOAD( SDL_OpenAudio );
	NV_SDL_LOAD( SDL_GetAudioStatus );
	NV_SDL_LOAD( SDL_PauseAudio );
	NV_SDL_LOAD( SDL_LoadWAV_RW );
	NV_SDL_LOAD( SDL_FreeWAV );
	NV_SDL_LOAD( SDL_BuildAudioCVT );
	NV_SDL_LOAD( SDL_ConvertAudio );
	NV_SDL_LOAD( SDL_MixAudio );
	NV_SDL_LOAD( SDL_LockAudio );
	NV_SDL_LOAD( SDL_UnlockAudio );
	NV_SDL_LOAD( SDL_CloseAudio );  

/* SDL_cpuinfo.h functions */
	NV_SDL_LOAD( SDL_HasRDTSC );
	NV_SDL_LOAD( SDL_HasMMX );
	NV_SDL_LOAD( SDL_HasMMXExt );
	NV_SDL_LOAD( SDL_Has3DNow );
	NV_SDL_LOAD( SDL_Has3DNowExt );
	NV_SDL_LOAD( SDL_HasSSE );
	NV_SDL_LOAD( SDL_HasSSE2 );
	NV_SDL_LOAD( SDL_HasAltiVec ); 

/* SDL_error.h functions */
	NV_SDL_LOAD( SDL_SetError );
	NV_SDL_LOAD( SDL_GetError );
	NV_SDL_LOAD( SDL_ClearError );
	NV_SDL_LOAD( SDL_Error );

/* SDL_active.h functions */
	NV_SDL_LOAD( SDL_GetAppState );

/* SDL_keyboard.h functions */
	NV_SDL_LOAD( SDL_EnableUNICODE );
	NV_SDL_LOAD( SDL_EnableKeyRepeat );
	NV_SDL_LOAD( SDL_GetKeyRepeat );
	NV_SDL_LOAD( SDL_GetKeyState );
	NV_SDL_LOAD( SDL_GetModState );
	NV_SDL_LOAD( SDL_SetModState );
	NV_SDL_LOAD( SDL_GetKeyName );
 
/* SDL_mouse.h functions */
	NV_SDL_LOAD( SDL_GetMouseState );
	NV_SDL_LOAD( SDL_GetRelativeMouseState );
	NV_SDL_LOAD( SDL_WarpMouse );
	NV_SDL_LOAD( SDL_CreateCursor );
	NV_SDL_LOAD( SDL_SetCursor );
	NV_SDL_LOAD( SDL_GetCursor );
	NV_SDL_LOAD( SDL_FreeCursor );
	NV_SDL_LOAD( SDL_ShowCursor );

/* SDL_joystick.h functions */
	NV_SDL_LOAD( SDL_NumJoysticks );
	NV_SDL_LOAD( SDL_JoystickName );
	NV_SDL_LOAD( SDL_JoystickOpen );
	NV_SDL_LOAD( SDL_JoystickOpened );
	NV_SDL_LOAD( SDL_JoystickIndex );
	NV_SDL_LOAD( SDL_JoystickNumAxes );
	NV_SDL_LOAD( SDL_JoystickNumBalls );
	NV_SDL_LOAD( SDL_JoystickNumHats );
	NV_SDL_LOAD( SDL_JoystickNumButtons );
	NV_SDL_LOAD( SDL_JoystickUpdate );
	NV_SDL_LOAD( SDL_JoystickEventState );
	NV_SDL_LOAD( SDL_JoystickGetAxis );
	NV_SDL_LOAD( SDL_JoystickGetHat );
	NV_SDL_LOAD( SDL_JoystickGetBall );
	NV_SDL_LOAD( SDL_JoystickGetButton );
	NV_SDL_LOAD( SDL_JoystickClose );

/* SDL_timer.h functions */
	NV_SDL_LOAD( SDL_GetTicks );
	NV_SDL_LOAD( SDL_Delay );
	NV_SDL_LOAD( SDL_SetTimer );
	NV_SDL_LOAD( SDL_AddTimer );
	NV_SDL_LOAD( SDL_RemoveTimer );

/* SDL_version.h functions */
	NV_SDL_LOAD( SDL_Linked_Version ); 

/* SDL_event.h functions */
	NV_SDL_LOAD( SDL_PumpEvents );
	NV_SDL_LOAD( SDL_PeepEvents );
	NV_SDL_LOAD( SDL_PollEvent );
	NV_SDL_LOAD( SDL_WaitEvent );
	NV_SDL_LOAD( SDL_PushEvent );
	NV_SDL_LOAD( SDL_SetEventFilter );
	NV_SDL_LOAD( SDL_GetEventFilter );
	NV_SDL_LOAD( SDL_EventState );

#	undef NV_SDL_LOAD
	return true;
}
#endif
