// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
/**
 * @file gl_context.hh
 * @author Kornel Kisielewicz epyon@chaosforge.org
 * @brief Context class
 */

#ifndef NV_GL_CONTEXT_HH
#define NV_GL_CONTEXT_HH

#include <nv/interface/context.hh>

namespace nv
{
	class gl_context : public context
	{
	public:
		gl_context();
		virtual void clear( const clear_state& cs );
		// temporary
		virtual void draw( primitive prim, const render_state& rs, program* p, vertex_array* va, size_t count );
		virtual const ivec4& get_viewport();
		virtual void set_viewport( const ivec4& viewport );
		virtual void apply_render_state( const render_state& state );
	private:
		void force_apply_render_state( const render_state& state );
		void force_apply_stencil_face( unsigned face, const stencil_test_face& stencil );
		void apply_stencil_test( const stencil_test& stencil );
		void apply_stencil_face( unsigned face, stencil_test_face& stencil, const stencil_test_face& new_stencil );
		void apply_scissor_test( const scissor_test& scissor );
		void apply_depth_test( const depth_test& depth );
		void apply_depth_mask( bool mask );
		void apply_depth_range( const depth_range& range );
		void apply_color_mask( const color_mask& mask );
		void apply_blending( const blending& blend );
		void apply_culling( const culling& cull );
		void enable( unsigned int what, bool value );

	private:
		vec4  m_clear_color;
		float m_clear_depth;
		int   m_clear_stencil;
	};

} // namespace nv

#endif // NV_CONTEXT_HH
