// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#include "nv/lib/sdl_image.hh"

#if defined( NV_SDL_DYNAMIC )

#include "nv/library.hh"

/* SDL_image.h functions */
const SDL_version * (NV_SDL_APIENTRY *IMG_Linked_Version) (void) = nullptr;
int (NV_SDL_APIENTRY *IMG_Init) (int flags) = nullptr;
void (NV_SDL_APIENTRY *IMG_Quit) (void) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadTyped_RW) (SDL_RWops *src, int freesrc, char *type) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_Load) (const char *file) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_Load_RW) (SDL_RWops *src, int freesrc) = nullptr;
int (NV_SDL_APIENTRY *IMG_isICO) (SDL_RWops *src) = nullptr;
int (NV_SDL_APIENTRY *IMG_isCUR) (SDL_RWops *src) = nullptr;
int (NV_SDL_APIENTRY *IMG_isBMP) (SDL_RWops *src) = nullptr;
int (NV_SDL_APIENTRY *IMG_isGIF) (SDL_RWops *src) = nullptr;
int (NV_SDL_APIENTRY *IMG_isJPG) (SDL_RWops *src) = nullptr;
int (NV_SDL_APIENTRY *IMG_isPNG) (SDL_RWops *src) = nullptr;
int (NV_SDL_APIENTRY *IMG_isTIF) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadICO_RW) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadCUR_RW) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadBMP_RW) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadGIF_RW) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadJPG_RW) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadPNG_RW) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadTGA_RW) (SDL_RWops *src) = nullptr;
SDL_Surface * (NV_SDL_APIENTRY *IMG_LoadTIF_RW) (SDL_RWops *src) = nullptr;

bool nv::load_sdl_image_library( const char* path )
{
#	define NV_SDL_IMAGE_LOAD( symbol ) *(void **) (&symbol) = sdl_image_library.get(#symbol);
	static nv::library sdl_image_library;
	if ( sdl_image_library.is_open() ) return true;
	sdl_image_library.open( path );

	NV_SDL_IMAGE_LOAD( IMG_Linked_Version );
	NV_SDL_IMAGE_LOAD( IMG_Init );
	NV_SDL_IMAGE_LOAD( IMG_Quit );
	NV_SDL_IMAGE_LOAD( IMG_LoadTyped_RW );
	NV_SDL_IMAGE_LOAD( IMG_Load );
	NV_SDL_IMAGE_LOAD( IMG_Load_RW );
	NV_SDL_IMAGE_LOAD( IMG_isICO );
	NV_SDL_IMAGE_LOAD( IMG_isCUR );
	NV_SDL_IMAGE_LOAD( IMG_isBMP );
	NV_SDL_IMAGE_LOAD( IMG_isGIF );
	NV_SDL_IMAGE_LOAD( IMG_isJPG );
	NV_SDL_IMAGE_LOAD( IMG_isPNG );
	NV_SDL_IMAGE_LOAD( IMG_isTIF );
	NV_SDL_IMAGE_LOAD( IMG_LoadICO_RW );
	NV_SDL_IMAGE_LOAD( IMG_LoadCUR_RW );
	NV_SDL_IMAGE_LOAD( IMG_LoadBMP_RW );
	NV_SDL_IMAGE_LOAD( IMG_LoadGIF_RW );
	NV_SDL_IMAGE_LOAD( IMG_LoadJPG_RW );
	NV_SDL_IMAGE_LOAD( IMG_LoadPNG_RW );
	NV_SDL_IMAGE_LOAD( IMG_LoadTGA_RW );
	NV_SDL_IMAGE_LOAD( IMG_LoadTIF_RW );

#	undef NV_SDL_IMAGE_LOAD
	return true;
}
#endif
