// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_TEXTURE_ATLAS_HH
#define NV_TEXTURE_ATLAS_HH

#include <nv/common.hh>
#include <nv/gfx/image.hh>
#include <glm/glm.hpp>
#include <vector>

namespace nv
{

	class texture_atlas : public image
	{
	public:
		texture_atlas( glm::ivec2 size, size_t depth );
		region get_region( glm::ivec2 size );
		void clear();
		const size_t get_used() const { return m_used; }
	protected:
		int fit( size_t index, glm::ivec2 size );
		void merge();
	private:
		size_t  m_used;
		std::vector<glm::ivec3> m_nodes;
	};

}

#endif // NV_TEXTURE_ATLAS_HH

